"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateScriptRoute = exports.getCreateScriptRequestHandler = void 0;
var _error_handler = require("../error_handler");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
var _scripts_library = require("../../../../common/api/endpoint/scripts_library");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreateScriptRequestHandler = endpointAppServices => {
  const logger = endpointAppServices.createLogger('createScriptRouteHandler');
  return async (context, req, res) => {
    logger.debug(`creating new script [${req.body.name}]`);
    try {
      const spaceId = (await context.securitySolution).getSpaceId();
      const user = (await context.core).security.authc.getCurrentUser();
      const esClient = (await context.core).elasticsearch.client.asCurrentUser;
      const scriptsClient = endpointAppServices.getScriptsLibraryClient(spaceId, (user === null || user === void 0 ? void 0 : user.username) || 'unknown', esClient);
      return res.ok({
        body: {
          data: await scriptsClient.create(req.body)
        }
      });
    } catch (err) {
      return (0, _error_handler.errorHandler)(logger, res, err);
    }
  };
};
exports.getCreateScriptRequestHandler = getCreateScriptRequestHandler;
const registerCreateScriptRoute = (router, endpointContext) => {
  router.versioned.post({
    access: 'public',
    path: _constants.SCRIPTS_LIBRARY_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      },
      authc: {
        enabled: true
      }
    },
    options: {
      body: {
        accepts: ['multipart/form-data'],
        output: 'stream',
        maxBytes: endpointContext.serverConfig.maxEndpointScriptFileSize
      },
      availability: {
        since: '9.4.0',
        stability: 'stable'
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _scripts_library.CreateScriptRequestSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canWriteScriptsLibrary']
  }, endpointContext.logFactory.get('createScriptRoute'), getCreateScriptRequestHandler(endpointContext.service)));
};
exports.registerCreateScriptRoute = registerCreateScriptRoute;