"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerOrphanActionsSpaceRoute = exports.getUpdateOrphanActionsSpaceHandler = exports.getReadOrphanActionsSpaceHandler = exports.UpdateOrphanActionsSpaceSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _reference_data = require("../../lib/reference_data");
var _error_handler = require("../error_handler");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * GET API handler
 * @param endpointService
 */
const getReadOrphanActionsSpaceHandler = endpointService => {
  const logger = endpointService.createLogger('ReadOrphanActionsSpaceHandler');
  return async (context, req, res) => {
    logger.debug(`Retrieving current orphan response actions space id`);
    try {
      const orphanSpaceRefData = await endpointService.getReferenceDataClient().get(_reference_data.REF_DATA_KEYS.orphanResponseActionsSpace);
      return res.ok({
        body: {
          data: {
            spaceId: orphanSpaceRefData.metadata.spaceId
          }
        }
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, res, error);
    }
  };
};

/**
 * Update handler
 * @param endpointService
 */
exports.getReadOrphanActionsSpaceHandler = getReadOrphanActionsSpaceHandler;
const getUpdateOrphanActionsSpaceHandler = endpointService => {
  const logger = endpointService.createLogger('UpdateOrphanActionsSpaceHandler');
  return async (context, req, res) => {
    logger.debug(`Updating orphan response actions space id`);
    try {
      const newSpaceIdValue = req.body.spaceId.trim();
      const refDataClient = endpointService.getReferenceDataClient();
      const updatedData = await refDataClient.get(_reference_data.REF_DATA_KEYS.orphanResponseActionsSpace);
      updatedData.metadata.spaceId = newSpaceIdValue;
      await refDataClient.update(_reference_data.REF_DATA_KEYS.orphanResponseActionsSpace, updatedData);
      return res.ok({
        body: {
          data: {
            spaceId: updatedData.metadata.spaceId
          }
        }
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, res, error);
    }
  };
};
exports.getUpdateOrphanActionsSpaceHandler = getUpdateOrphanActionsSpaceHandler;
const registerOrphanActionsSpaceRoute = (router, endpointService) => {
  const logger = endpointService.createLogger('OrphanActionsSpaceRoute');
  router.versioned.get({
    access: 'internal',
    path: _constants.ORPHAN_ACTIONS_SPACE_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '1',
    validate: false
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canReadAdminData']
  }, logger, getReadOrphanActionsSpaceHandler(endpointService)));
  router.versioned.post({
    access: 'internal',
    path: _constants.ORPHAN_ACTIONS_SPACE_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '1',
    validate: {
      request: UpdateOrphanActionsSpaceSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canWriteAdminData']
  }, logger, getUpdateOrphanActionsSpaceHandler(endpointService)));
};
exports.registerOrphanActionsSpaceRoute = registerOrphanActionsSpaceRoute;
const UpdateOrphanActionsSpaceSchema = exports.UpdateOrphanActionsSpaceSchema = {
  body: _configSchema.schema.object({
    spaceId: _configSchema.schema.string({
      minLength: 1,
      defaultValue: ''
    })
  })
};