"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scriptsLibrarySavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScriptsLibraryAttributesSchemaV1 = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  platform: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  hash: _configSchema.schema.maybe(_configSchema.schema.string()),
  requires_input: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  instructions: _configSchema.schema.maybe(_configSchema.schema.string()),
  example: _configSchema.schema.maybe(_configSchema.schema.string()),
  pathToExecutable: _configSchema.schema.maybe(_configSchema.schema.string()),
  created_by: _configSchema.schema.string(),
  updated_by: _configSchema.schema.string()
});
const scriptsLibrarySavedObjectType = exports.scriptsLibrarySavedObjectType = {
  name: _constants.SCRIPTS_LIBRARY_SAVED_OBJECT_TYPE,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  namespaceType: 'multiple',
  hidden: true,
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      name: {
        type: 'keyword'
      },
      platform: {
        type: 'keyword'
      },
      hash: {
        type: 'keyword'
      },
      requires_input: {
        type: 'boolean'
      },
      description: {
        type: 'keyword'
      },
      instructions: {
        type: 'keyword'
      },
      example: {
        type: 'keyword'
      },
      pathToExecutable: {
        type: 'keyword'
      },
      created_by: {
        type: 'keyword'
      },
      updated_by: {
        type: 'keyword'
      }
      // FYI: the created_at/_by fields are auto populated by the so framework
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: ScriptsLibraryAttributesSchemaV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: ScriptsLibraryAttributesSchemaV1
      }
    }
  }
};