"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyWatcher = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _pRetry = _interopRequireDefault(require("p-retry"));
var _common = require("@kbn/spaces-plugin/common");
var _policy_config = require("../../../../common/license/policy_config");
var _policy = require("../../../../common/endpoint/service/policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PolicyWatcher {
  constructor(endpointServices) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    this.endpointServices = endpointServices;
    this.logger = endpointServices.createLogger('PolicyWatcher');
  }
  start(licenseService) {
    var _licenseService$getLi;
    this.subscription = (_licenseService$getLi = licenseService.getLicenseInformation$()) === null || _licenseService$getLi === void 0 ? void 0 : _licenseService$getLi.subscribe(this.watch.bind(this));
  }
  stop() {
    if (this.subscription) {
      this.subscription.unsubscribe();
      this.subscription = undefined;
    }
  }
  async watch(license) {
    const fleetServices = this.endpointServices.getInternalFleetServices();
    const esClient = this.endpointServices.getInternalEsClient();
    this.logger.debug(`Checking endpoint policies for compliance with license level [${license.type}]`);
    let totalUpdates = 0;
    let page = 1;
    let response = {
      items: [],
      total: 0,
      page: 0,
      perPage: 0
    };
    do {
      try {
        await (0, _pRetry.default)(async () => {
          const soClient = this.endpointServices.savedObjects.createInternalUnscopedSoClient(false);
          response = await fleetServices.packagePolicy.list(soClient, {
            page: page++,
            perPage: 100,
            kuery: fleetServices.endpointPolicyKuery,
            spaceId: '*'
          });
        }, {
          retries: 3,
          minTimeout: 1000,
          maxTimeout: 5000,
          onFailedAttempt: error => {
            if (error.retriesLeft) {
              this.logger.debug(`attempt ${error.attemptNumber} to fetch endpoint policies failed. Trying again. [ERROR: ${error.message}]`);
              return;
            }
            this.logger.warn(`Unable to verify endpoint policies in line with license change: failed to fetch package policies: ${error.message}`);
          }
        });
      } catch {
        return;
      }
      this.logger.debug(() => `Processing page [${page - 1}] with [${response.items.length}] endpoint policies`);
      for (const policy of response.items) {
        const updatePolicy = (0, _policy.getPolicyDataForUpdate)(policy);
        const policyConfig = updatePolicy.inputs[0].config.policy.value;
        try {
          if (!(0, _policy_config.isEndpointPolicyValidForLicense)(policyConfig, license)) {
            var _policy$spaceIds$at, _policy$spaceIds;
            this.logger.debug(`Endpoint policy [${policy.id}] needs updates in order to make it compliant with License [${license.type}]`);
            updatePolicy.inputs[0].config.policy.value = (0, _policy_config.unsetPolicyFeaturesAccordingToLicenseLevel)(policyConfig, license);
            const soClientForPolicyUpdate = this.endpointServices.savedObjects.createInternalScopedSoClient({
              spaceId: (_policy$spaceIds$at = (_policy$spaceIds = policy.spaceIds) === null || _policy$spaceIds === void 0 ? void 0 : _policy$spaceIds.at(0)) !== null && _policy$spaceIds$at !== void 0 ? _policy$spaceIds$at : _common.DEFAULT_SPACE_ID,
              readonly: false
            });
            await (0, _pRetry.default)(async () => {
              await fleetServices.packagePolicy.update(soClientForPolicyUpdate, esClient, policy.id, updatePolicy);
            }, {
              retries: 3,
              minTimeout: 1000,
              maxTimeout: 5000,
              onFailedAttempt: error => {
                if (error.retriesLeft) {
                  this.logger.debug(`attempt ${error.attemptNumber} to update endpoint policy [${policy.id}] failed. Trying again. [ERROR: ${error.message}]`);
                  return;
                }
                this.logger.warn(`Unable to remove platinum features from policy ${policy.id}`);
                this.logger.warn(error.message);
              }
            });
            totalUpdates++;
          }
        } catch (error) {
          this.logger.warn(`Failure while attempting to verify Endpoint Policy features for policy [${policy.id}]`);
          this.logger.warn(error);
        }
      }
    } while (response.page * response.perPage < response.total);
    this.logger.debug(`Checks of endpoint policies for compliance with License [${license.type}] done.${totalUpdates > 0 ? ` [${totalUpdates}] policies were updated` : ''}`);
  }
}
exports.PolicyWatcher = PolicyWatcher;