"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnhancedIndexExplorerAnnotation = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnhancedIndexExplorerAnnotation = exports.EnhancedIndexExplorerAnnotation = _langgraph.Annotation.Root({
  messages: (0, _langgraph.Annotation)({
    reducer: _langgraph.messagesStateReducer,
    default: () => []
  }),
  input: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => undefined
  }),
  discoveredResources: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => []
  }),
  indexPatterns: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => []
  }),
  shortlistedIndexPatterns: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => []
  }),
  selectedResources: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => []
  }),
  finalRecommendation: (0, _langgraph.Annotation)({
    reducer: (currentValue, newValue) => newValue !== null && newValue !== void 0 ? newValue : currentValue,
    default: () => undefined
  })
});