"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnhancedIndexExplorerGraph = void 0;
var _langgraph = require("@langchain/langgraph");
var _state = require("./state");
var _constants = require("./constants");
var _explore_indices = require("./nodes/explore_indices/explore_indices");
var _select_best_indices = require("./nodes/select_best_indices/select_best_indices");
var _validate_index_access = require("./nodes/validate_index_access/validate_index_access");
var _shortlist_index_patterns = require("../select_index_pattern/nodes/shortlist_index_patterns/shortlist_index_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEnhancedIndexExplorerGraph = async ({
  createLlmInstance,
  esClient,
  inference,
  request,
  connectorId,
  logger
}) => {
  const shortlistIndexPatterns = await (0, _shortlist_index_patterns.getShortlistIndexPatterns)({
    createLlmInstance
  });
  const graph = new _langgraph.StateGraph(_state.EnhancedIndexExplorerAnnotation).addNode(_constants.EXPLORE_INDICES, (0, _explore_indices.exploreIndices)({
    esClient,
    createLlmInstance,
    inference,
    request,
    connectorId
  }), {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addNode(_constants.GET_SHORTLIST_INDEX_PATTERNS, shortlistIndexPatterns, {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addNode(_constants.SELECT_BEST_INDICES, (0, _select_best_indices.selectBestIndices)({
    logger
  }), {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addNode(_constants.VALIDATE_INDEX_ACCESS, (0, _validate_index_access.validateIndexAccess)({
    esClient
  }), {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addEdge(_langgraph.START, _constants.EXPLORE_INDICES).addEdge(_constants.EXPLORE_INDICES, _constants.GET_SHORTLIST_INDEX_PATTERNS).addEdge(_constants.GET_SHORTLIST_INDEX_PATTERNS, _constants.SELECT_BEST_INDICES).addEdge(_constants.SELECT_BEST_INDICES, _constants.VALIDATE_INDEX_ACCESS).addEdge(_constants.VALIDATE_INDEX_ACCESS, _langgraph.END).compile();
  return graph;
};
exports.getEnhancedIndexExplorerGraph = getEnhancedIndexExplorerGraph;