"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssetMisconfigurationsQuery = void 0;
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MISCONFIGURATION_FIELDS = ['rule.name', 'rule.description', 'rule.section', 'rule.tags', 'rule.benchmark.name', 'rule.benchmark.id', 'rule.benchmark.rule_number', 'rule.benchmark.version', 'resource.name', 'resource.type', 'resource.sub_type', 'result.evaluation', '@timestamp'];
const getAssetMisconfigurationsQuery = ({
  anonymizationFields,
  resourceId
}) => {
  const fields = anonymizationFields.filter(field => field.allowed && MISCONFIGURATION_FIELDS.includes(field.field)).map(field => ({
    field: field.field,
    include_unmapped: true
  }));
  return {
    index: _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN,
    size: 50,
    // 50 is adequate as usually per resource there are max 10 findings, though in case of 3p data it might be more
    sort: [{
      '@timestamp': {
        order: 'desc'
      }
    }],
    fields,
    query: {
      bool: {
        filter: [{
          term: {
            'resource.id': resourceId
          }
        }, {
          term: {
            'result.evaluation': _cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED
          }
        }, {
          range: {
            '@timestamp': {
              gte: `now-${_cloudSecurityPostureCommon.LATEST_FINDINGS_RETENTION_POLICY}`,
              lte: 'now'
            }
          }
        }]
      }
    }
  };
};
exports.getAssetMisconfigurationsQuery = getAssetMisconfigurationsQuery;