"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ASSET_MISCONFIGURATIONS_TOOL_DESCRIPTION = exports.ASSET_MISCONFIGURATIONS_TOOL = void 0;
var _tools = require("@langchain/core/tools");
var _zod = require("@kbn/zod");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _helpers = require("@kbn/elastic-assistant-plugin/server/lib/langchain/helpers");
var _common = require("../../../../common");
var _get_asset_misconfigurations_query = require("./get_asset_misconfigurations_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_MISCONFIGURATIONS_TOOL_DESCRIPTION = exports.ASSET_MISCONFIGURATIONS_TOOL_DESCRIPTION = "Call this to retrieve security misconfigurations and compliance violations for a specific cloud asset. The resource_id must be the full cloud resource identifier (e.g., AWS ARN like 'arn:aws:ec2:region:account:resource-type/resource-id', Azure resource path, or GCP resource name). This returns failed findings including rule details, benchmark information, and compliance impact.";
const ASSET_MISCONFIGURATIONS_TOOL = exports.ASSET_MISCONFIGURATIONS_TOOL = {
  id: 'asset-misconfigurations-tool',
  name: 'AssetMisconfigurationsTool',
  // note: this description is overwritten when `getTool` is called
  // local definitions exist ../elastic_assistant/server/lib/prompt/tool_prompts.ts
  // local definitions can be overwritten by security-ai-prompt integration definitions
  description: ASSET_MISCONFIGURATIONS_TOOL_DESCRIPTION,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      anonymizationFields,
      request
    } = params;
    return (0, _helpers.requestHasRequiredAnonymizationParams)(request) && anonymizationFields != null;
  },
  async getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      anonymizationFields,
      esClient,
      onNewReplacements,
      replacements
    } = params;
    return (0, _tools.tool)(async input => {
      var _result$hits, _result$hits$hits;
      if ((0, _elasticAssistantCommon.isDenied)({
        anonymizationFields,
        field: 'resource.id'
      })) {
        return 'The field resource.id is denied by the anonymization settings and cannot be used to query misconfigurations. Please modify the anonymization settings and try again.';
      }
      const query = (0, _get_asset_misconfigurations_query.getAssetMisconfigurationsQuery)({
        anonymizationFields: anonymizationFields !== null && anonymizationFields !== void 0 ? anonymizationFields : [],
        resourceId: input.resource_id
      });
      const result = await esClient.search(query);
      const findings = ((_result$hits = result.hits) === null || _result$hits === void 0 ? void 0 : (_result$hits$hits = _result$hits.hits) === null || _result$hits$hits === void 0 ? void 0 : _result$hits$hits.map(hit => {
        const transformed = (0, _elasticAssistantCommon.transformRawData)({
          anonymizationFields,
          currentReplacements: replacements !== null && replacements !== void 0 ? replacements : {},
          getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
          onNewReplacements,
          rawData: (0, _elasticAssistantCommon.getRawDataOrDefault)(hit.fields)
        });
        return transformed;
      })) || [];
      return JSON.stringify({
        resource_id: input.resource_id,
        findings_count: findings.length,
        findings
      });
    }, {
      name: 'AssetMisconfigurationsTool',
      description: params.description || ASSET_MISCONFIGURATIONS_TOOL_DESCRIPTION,
      schema: _zod.z.object({
        resource_id: _zod.z.string().min(1).describe('The full cloud resource identifier (ARN, Azure Resource ID, or GCP Resource Name) of the asset. Examples: "arn:aws:ec2:us-east-1:123456789:security-group/sg-abc123", "/subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.Compute/virtualMachines/vm-name". Use entity.id field from entity data, NOT Elasticsearch document IDs or UUIDs.')
      }),
      tags: ['asset-misconfigurations', 'compliance']
    });
  }
};