"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.QueryTabContentComponent = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _common = require("@kbn/data-plugin/common");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _constants = require("../../../../../data_view_manager/constants");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _use_browser_fields = require("../../../../../data_view_manager/hooks/use_browser_fields");
var _use_fetch_notes = require("../../../../../notes/hooks/use_fetch_notes");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _left = require("../../../../../flyout/document_details/left");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_timeline_data_filters = require("../../../../containers/use_timeline_data_filters");
var _constants2 = require("../../../../../common/store/inputs/constants");
var _use_invalid_filter_query = require("../../../../../common/hooks/use_invalid_filter_query");
var _store = require("../../../../store");
var _containers = require("../../../../containers");
var _kibana = require("../../../../../common/lib/kibana");
var _header = require("./header");
var _kuery = require("../../../../../common/lib/kuery");
var _refetch_timeline = require("../../refetch_timeline");
var _timeline = require("../../../../../../common/types/timeline");
var _store2 = require("../../../../../common/store");
var _defaults = require("../../../../store/defaults");
var _containers2 = require("../../../../../sourcerer/containers");
var _helpers = require("../../../../../helpers");
var _unified_timeline_body = require("../../body/unified_timeline_body");
var _utils = require("../shared/utils");
var _use_timeline_columns = require("../shared/use_timeline_columns");
var _use_timeline_control_columns = require("../shared/use_timeline_control_columns");
var _telemetry = require("../../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/query/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const compareQueryProps = (prevProps, nextProps) => prevProps.kqlMode === nextProps.kqlMode && prevProps.kqlQueryExpression === nextProps.kqlQueryExpression && (0, _fastDeepEqual.default)(prevProps.filters, nextProps.filters);
const QueryTabContentComponent = ({
  activeTab,
  columns,
  dataProviders,
  end,
  filters,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  kqlMode,
  kqlQueryExpression,
  kqlQueryLanguage,
  rowRenderers,
  show,
  showCallOutUnauthorizedMsg,
  start,
  status,
  sort,
  timerangeKind,
  eventIdToNoteIds
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status: sourcererStatus
  } = (0, _use_data_view.useDataView)(_constants.PageScope.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_constants.PageScope.timeline);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.PageScope.timeline);
  const {
    browserFields: oldBrowserFields,
    dataViewId: oldDataViewId,
    loading: oldLoadingSourcerer,
    // important to get selectedPatterns from useSourcererDataView
    // in order to include the exclude filters in the search that are not stored in the timeline
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers2.useSourcererDataView)(_constants.PageScope.timeline);
  const loadingSourcerer = (0, _react.useMemo)(() => newDataViewPickerEnabled ? sourcererStatus !== 'ready' : oldLoadingSourcerer, [newDataViewPickerEnabled, oldLoadingSourcerer, sourcererStatus]);
  const browserFields = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields, [experimentalBrowserFields, newDataViewPickerEnabled, oldBrowserFields]);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns, [experimentalSelectedPatterns, newDataViewPickerEnabled, oldSelectedPatterns]);
  const dataViewId = (0, _react.useMemo)(() => {
    var _experimentalDataView;
    return newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : oldDataViewId;
  }, [experimentalDataView.id, newDataViewPickerEnabled, oldDataViewId]);

  /*
   * `pageIndex` needs to be maintained for each table in each tab independently
   * and consequently it cannot be the part of common redux state
   * of the timeline.
   *
   */
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const {
    uiSettings,
    telemetry,
    timelineDataService
  } = (0, _kibana.useKibana)().services;
  const {
    query: {
      filterManager: timelineFilterManager
    }
  } = timelineDataService;
  const getManageTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const currentTimeline = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const {
    sampleSize
  } = currentTimeline;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression.trim(),
    language: kqlQueryLanguage
  }), [kqlQueryExpression, kqlQueryLanguage]);
  const runtimeMappings = (0, _react.useMemo)(() => {
    return newDataViewPickerEnabled ? experimentalDataView.getRuntimeMappings() : oldSourcererDataViewSpec.runtimeFieldMap;
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataViewSpec.runtimeFieldMap]);
  const combinedQueries = (0, _react.useMemo)(() => {
    return (0, _kuery.combineQueries)({
      config: esQueryConfig,
      dataProviders,
      dataViewSpec: oldSourcererDataViewSpec,
      dataView: experimentalDataView,
      browserFields,
      filters,
      kqlQuery,
      kqlMode
    });
  }, [esQueryConfig, dataProviders, oldSourcererDataViewSpec, experimentalDataView, browserFields, filters, kqlQuery, kqlMode]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: timelineId,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    kqlError: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.kqlError,
    query: kqlQuery,
    startDate: start,
    endDate: end
  });
  const isBlankTimeline = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined;
  const canQueryTimeline = (0, _react.useMemo)(() => combinedQueries != null && loadingSourcerer != null && !loadingSourcerer && !(0, _fp.isEmpty)(start) && !(0, _fp.isEmpty)(end) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== undefined, [combinedQueries, end, loadingSourcerer, start]);
  const timelineQuerySortField = (0, _react.useMemo)(() => {
    return sort.map(({
      columnId,
      columnType,
      esTypes,
      sortDirection
    }) => ({
      field: columnId,
      direction: sortDirection,
      esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : [],
      type: columnType
    }));
  }, [sort]);
  const {
    augmentedColumnHeaders,
    defaultColumns,
    timelineQueryFieldsFromColumns
  } = (0, _use_timeline_columns.useTimelineColumns)(columns);
  const [dataLoadingState, {
    events,
    inspect,
    totalCount,
    loadNextBatch,
    refreshedAt,
    refetch
  }] = (0, _containers.useTimelineEvents)({
    dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
    endDate: end,
    fields: timelineQueryFieldsFromColumns,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    id: timelineId,
    indexNames: selectedPatterns,
    language: kqlQuery.language,
    limit: sampleSize,
    runtimeMappings,
    skip: !canQueryTimeline,
    sort: timelineQuerySortField,
    startDate: start,
    timerangeKind
  });
  const {
    onLoad: loadNotesOnEventsLoad
  } = (0, _use_fetch_notes.useFetchNotes)();
  (0, _react.useEffect)(() => {
    // This useEffect loads the notes only for the events on the current
    // page.
    const eventsOnCurrentPage = events.slice(itemsPerPage * pageIndex, itemsPerPage * (pageIndex + 1));
    if (eventsOnCurrentPage.length > 0) {
      loadNotesOnEventsLoad(eventsOnCurrentPage);
    }
  }, [events, pageIndex, itemsPerPage, loadNotesOnEventsLoad]);

  /**
   *
   * Triggers on Datagrid page change
   *
   */
  const onUpdatePageIndex = (0, _react.useCallback)(newPageIndex => setPageIndex(newPageIndex), []);
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const onToggleShowNotes = (0, _react.useCallback)(eventId => {
    if (!eventId) {
      return;
    }
    const indexName = selectedPatterns.join(',');
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName,
          scopeId: timelineId
        }
      },
      left: {
        id: _panel_keys.DocumentDetailsLeftPanelKey,
        path: {
          tab: _left.LeftPanelNotesTab
        },
        params: {
          id: eventId,
          indexName,
          scopeId: timelineId
        }
      }
    });
    telemetry.reportEvent(_telemetry.NotesEventTypes.OpenNoteInExpandableFlyoutClicked, {
      location: timelineId
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: timelineId,
      panel: 'left'
    });
  }, [openFlyout, selectedPatterns, telemetry, timelineId]);
  const leadingControlColumns = (0, _use_timeline_control_columns.useTimelineControlColumn)({
    timelineId,
    refetch,
    events,
    eventIdToNoteIds,
    onToggleShowNotes
  });
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.initializeTimelineSettings({
      id: timelineId,
      defaultColumns
    }));
  }, [dispatch, timelineId, defaultColumns]);
  const isQueryLoading = (0, _react.useMemo)(() => [_unifiedDataTable.DataLoadingState.loading, _unifiedDataTable.DataLoadingState.loadingMore].includes(dataLoadingState), [dataLoadingState]);

  // NOTE: The timeline is blank after browser FORWARD navigation (after using back button to navigate to
  // the previous page from the timeline), yet we still see total count. This is because the timeline
  // is not getting refreshed when using browser navigation.
  const showEventsCountBadge = !isBlankTimeline && totalCount >= 0;

  // <Synchronisation of the timeline data service>
  // Sync the timerange
  const timelineFilters = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(timelineId));
  (0, _react.useEffect)(() => {
    timelineDataService.query.timefilter.timefilter.setTime({
      from: timelineFilters.from,
      to: timelineFilters.to
    });
  }, [timelineDataService.query.timefilter.timefilter, timelineFilters.from, timelineFilters.to]);

  // Sync the base query
  (0, _react.useEffect)(() => {
    timelineDataService.query.queryString.setQuery(
    // We're using the base query of all combined queries here, to account for all
    // of timeline's query dependencies (data providers, query etc.)
    (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.baseKqlQuery) || {
      language: kqlQueryLanguage,
      query: ''
    });
  }, [timelineDataService, combinedQueries, kqlQueryLanguage]);
  // </Synchronisation of the timeline data service>

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_refetch_timeline.TimelineRefetch, {
    id: `${timelineId}-${_timeline.TimelineTabs.query}`,
    inputId: _constants2.InputsModelId.timeline,
    inspect: inspect,
    loading: isQueryLoading,
    refetch: refetch,
    skip: !canQueryTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_unified_timeline_body.UnifiedTimelineBody, {
    header: /*#__PURE__*/_react.default.createElement(_header.QueryTabHeader, {
      activeTab: activeTab,
      dataViewId: dataViewId,
      currentIndices: currentTimeline.indexNames,
      filterManager: timelineFilterManager,
      show: show && activeTab === _timeline.TimelineTabs.query,
      showCallOutUnauthorizedMsg: showCallOutUnauthorizedMsg,
      status: status,
      timelineId: timelineId,
      showEventsCountBadge: showEventsCountBadge,
      totalCount: totalCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 11
      }
    }),
    columns: augmentedColumnHeaders,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    sort: sort,
    events: events,
    refetch: refetch,
    dataLoadingState: dataLoadingState,
    totalCount: isBlankTimeline ? 0 : totalCount,
    leadingControlColumns: leadingControlColumns,
    onFetchMoreRecords: loadNextBatch,
    activeTab: activeTab,
    updatedAt: refreshedAt,
    isTextBasedQuery: false,
    onUpdatePageIndex: onUpdatePageIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }));
};
exports.QueryTabContentComponent = QueryTabContentComponent;
const makeMapStateToProps = () => {
  const getShowCallOutUnauthorizedMsg = _store.timelineSelectors.getShowCallOutUnauthorizedMsg();
  const getTimeline = _store.timelineSelectors.getTimelineByIdSelector();
  const getKqlQueryTimeline = _store.timelineSelectors.getKqlFilterKuerySelector();
  const getInputsTimeline = _store2.inputsSelectors.getTimelineSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline, _kqlQueryTimeline$exp, _kqlQueryTimeline$exp2, _kqlQueryTimeline$kin;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const {
      activeTab,
      columns,
      dataProviders,
      eventIdToNoteIds,
      filters,
      itemsPerPage,
      itemsPerPageOptions,
      kqlMode,
      show,
      sort,
      status,
      timelineType
    } = timeline;
    const kqlQueryTimeline = getKqlQueryTimeline(state, timelineId);
    const timelineFilter = kqlMode === 'filter' ? filters || [] : [];

    // return events on empty search
    const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)((_kqlQueryTimeline$exp = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp !== void 0 ? _kqlQueryTimeline$exp : '') && timelineType === 'template' ? ' ' : (_kqlQueryTimeline$exp2 = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp2 !== void 0 ? _kqlQueryTimeline$exp2 : '';
    const kqlQueryLanguage = (0, _fp.isEmpty)(dataProviders) && timelineType === 'template' ? 'kuery' : (_kqlQueryTimeline$kin = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.kind) !== null && _kqlQueryTimeline$kin !== void 0 ? _kqlQueryTimeline$kin : 'kuery';
    return {
      activeTab,
      columns,
      dataProviders,
      end: input.timerange.to,
      filters: timelineFilter,
      timelineId,
      eventIdToNoteIds,
      itemsPerPage,
      itemsPerPageOptions,
      kqlMode,
      kqlQueryExpression,
      kqlQueryLanguage,
      showCallOutUnauthorizedMsg: getShowCallOutUnauthorizedMsg(state),
      show,
      sort,
      start: input.timerange.from,
      status,
      timerangeKind: input.timerange.kind
    };
  };
  return mapStateToProps;
};
const connector = (0, _reactRedux.connect)(makeMapStateToProps);
const QueryTabContent = exports.default = connector(/*#__PURE__*/_react.default.memo(QueryTabContentComponent, (prevProps, nextProps) => compareQueryProps(prevProps, nextProps) && prevProps.activeTab === nextProps.activeTab && (0, _utils.isTimerangeSame)(prevProps, nextProps) && prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.show === nextProps.show && prevProps.showCallOutUnauthorizedMsg === nextProps.showCallOutUnauthorizedMsg && prevProps.status === nextProps.status && prevProps.status === nextProps.status && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.eventIdToNoteIds, nextProps.eventIdToNoteIds) && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.dataProviders, nextProps.dataProviders) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions) && (0, _fastDeepEqual.default)(prevProps.sort, nextProps.sort)));

// eslint-disable-next-line import/no-default-export