"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTabFallback = exports.LazyTimelineTabRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_selector = require("../../../../common/hooks/use_selector");
var _selectors = require("../../../store/selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/lazy_timeline_tab_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * We check for the timeline open status to request the fields for the fields browser. The fields request
 * is often a much longer running request for customers with a significant number of indices and fields in those indices.
 * This request should only be made after the user has decided to interact with a specific tab in the timeline to prevent any performance impacts
 * to the underlying security solution views, as this query will always run when the timeline exists on the page.
 *
 * `hasTimelineTabBeenOpenedOnce` - We want to keep timeline loading times as fast as possible after the user
 * has chosen to interact with timeline at least once, so we use this flag to prevent re-requesting of this fields data
 * every time timeline is closed and re-opened after the first interaction.
 */
const LazyTimelineTabRenderer = exports.LazyTimelineTabRenderer = /*#__PURE__*/_react.default.memo(({
  children,
  dataTestSubj,
  shouldShowTab,
  timelineId
}) => {
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    show
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, timelineId));
  const [hasTimelineTabBeenOpenedOnce, setHasTimelineTabBeenOpenedOnce] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!hasTimelineTabBeenOpenedOnce && show && shouldShowTab) {
      setHasTimelineTabBeenOpenedOnce(true);
    }
  }, [hasTimelineTabBeenOpenedOnce, shouldShowTab, show]);
  return /*#__PURE__*/_react.default.createElement("div", {
    // The shouldShowTab check here is necessary for the flex container to accurately size to the modal window when it's opened
    css: (0, _react2.css)`
          display: ${shouldShowTab ? 'flex' : 'none'};
          overflow: hidden;
          flex: 1;
        `,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, hasTimelineTabBeenOpenedOnce ? children : /*#__PURE__*/_react.default.createElement(TimelineTabFallback, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 52
    }
  }));
});
LazyTimelineTabRenderer.displayName = 'LazyTimelineTabRenderer';
const TimelineTabFallback = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  justifyContent: "spaceAround",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  css: (0, _react2.css)`
        justify-content: center;
      `,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
  size: "xxl",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 7
  }
})));
exports.TimelineTabFallback = TimelineTabFallback;