"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuricataRefs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _suricata_links = require("./suricata_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/suricata/suricata_refs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinkEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  display: inline;
`;
LinkEuiFlexItem.displayName = 'LinkEuiFlexItem';
const SuricataRefs = exports.SuricataRefs = /*#__PURE__*/_react.default.memo(({
  signatureId
}) => {
  const [linksFromSignature, setLinksFromSignature] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    async function getLinks() {
      if (signatureId != null) {
        try {
          const links = await (0, _suricata_links.getLinksFromSignature)(signatureId);
          if (isSubscribed && links != null) {
            setLinksFromSignature(links);
          }
        } catch (exc) {
          setLinksFromSignature(undefined);
        }
      } else if (isSubscribed) {
        setLinksFromSignature(undefined);
      }
    }
    getLinks();
    return () => {
      isSubscribed = false;
    };
  }, [signatureId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "suricataRefs",
    gutterSize: "none",
    justifyContent: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, linksFromSignature && linksFromSignature.map(link => /*#__PURE__*/_react.default.createElement(LinkEuiFlexItem, {
    key: link,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: link,
    color: "subdued",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, link))));
});
SuricataRefs.displayName = 'SuricataRefs';