"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../common/api/timeline");
var _import_data_modal = require("../../../common/components/import_data_modal");
var _utility_bar = require("../../../common/components/utility_bar");
var _api = require("../../containers/api");
var _user_privileges = require("../../../common/components/user_privileges");
var _edit_timeline_batch_actions = require("./edit_timeline_batch_actions");
var _edit_timeline_actions = require("./edit_timeline_actions");
var _export_timeline = require("./export_timeline");
var _search_row = require("./search_row");
var _timelines_table = require("./timelines_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _utils = require("./utils");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/open_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryText = _styledComponents.default.span`
  white-space: normal;
  word-break: break-word;
`;
const OpenTimeline = exports.OpenTimeline = /*#__PURE__*/_react.default.memo(({
  deleteTimelines,
  defaultPageSize,
  favoriteCount,
  isLoading,
  itemIdToExpandedNotesRowMap,
  importDataModalToggle,
  onCreateRule,
  onCreateRuleFromEql,
  onDeleteSelected,
  onlyFavorites,
  onOpenTimeline,
  onQueryChange,
  onSelectionChange,
  onTableChange,
  onToggleOnlyFavorites,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  query,
  refetch,
  searchResults,
  selectedItems,
  sortDirection,
  setImportDataModalToggle,
  sortField,
  timelineType = _timeline.TimelineTypeEnum.default,
  timelineStatus,
  timelineFilter,
  templateTimelineFilter,
  totalSearchResultsCount
}) => {
  var _actionItem$title;
  const {
    actionItem,
    enableExportTimelineDownloader,
    isEnableDownloader,
    isDeleteTimelineModalOpen,
    onOpenDeleteTimelineModal,
    onCompleteEditTimelineAction
  } = (0, _edit_timeline_actions.useEditTimelineActions)();
  const tableRef = (0, _react.useRef)(null);
  const {
    timelinePrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    getBatchItemsPopoverContent
  } = (0, _edit_timeline_batch_actions.useEditTimelineBatchActions)({
    deleteTimelines: timelinePrivileges.crud ? deleteTimelines : undefined,
    selectedItems,
    tableRef,
    timelineType
  });
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const nTemplates = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.open.timeline.showingNTemplatesLabel",
    defaultMessage: "{totalSearchResultsCount} {totalSearchResultsCount, plural, one {template} other {templates}} {with}",
    values: {
      totalSearchResultsCount,
      with: /*#__PURE__*/_react.default.createElement(QueryText, {
        "data-test-subj": "selectable-query-text",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      }, query.trim().length ? `${i18n.WITH} "${query.trim()}"` : '')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), [totalSearchResultsCount, query]);
  const nTimelines = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.open.timeline.showingNTimelinesLabel",
    defaultMessage: "{totalSearchResultsCount} {totalSearchResultsCount, plural, one {timeline} other {timelines}} {with}",
    values: {
      totalSearchResultsCount,
      with: /*#__PURE__*/_react.default.createElement(QueryText, {
        "data-test-subj": "selectable-query-text",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 15
        }
      }, query.trim().length ? `${i18n.WITH} "${query.trim()}"` : '')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }), [totalSearchResultsCount, query]);
  const actionItemId = (0, _react.useMemo)(() => actionItem != null && actionItem.savedObjectId != null ? [actionItem.savedObjectId] : [], [actionItem]);
  const actionItemSavedSearchId = (0, _react.useMemo)(() => {
    return actionItem != null && actionItem.savedSearchId != null ? [actionItem.savedSearchId] : undefined;
  }, [actionItem]);
  const onRefreshBtnClick = (0, _react.useCallback)(() => {
    if (refetch != null) {
      refetch();
    }
  }, [refetch]);
  const handleCloseModal = (0, _react.useCallback)(() => {
    if (setImportDataModalToggle != null) {
      setImportDataModalToggle(false);
    }
  }, [setImportDataModalToggle]);
  const handleComplete = (0, _react.useCallback)(importResponse => {
    if (importResponse.success_count && importResponse.success_count > 0) {
      addSuccess(i18n.SUCCESSFULLY_IMPORTED_TIMELINES(importResponse.success_count));
    }
    if (importResponse.errors && importResponse.errors.length > 0) {
      const ruleError = (0, _utils.formatError)(importResponse);
      addError(ruleError, {
        title: i18n.IMPORT_FAILED(importResponse.errors.length)
      });
    }
    if (setImportDataModalToggle != null) {
      setImportDataModalToggle(false);
    }
    if (refetch != null) {
      refetch();
    }
  }, [setImportDataModalToggle, refetch, addSuccess, addError]);
  const actionTimelineToShow = (0, _react.useMemo)(() => {
    if (timelinePrivileges.crud) {
      const createRule = ['createRule'];
      const createRuleFromEql = ['createRuleFromEql'];
      const timelineActions = ['createFrom', 'duplicate', ...(onCreateRule != null ? createRule : []), ...(onCreateRuleFromEql != null ? createRuleFromEql : [])];
      if (timelineStatus !== _timeline.TimelineStatusEnum.immutable) {
        timelineActions.push('export');
        timelineActions.push('selectable');
      }
      if (onDeleteSelected != null && deleteTimelines != null && timelineStatus !== _timeline.TimelineStatusEnum.immutable) {
        timelineActions.push('delete');
      }
      return timelineActions;
    }
    // user with read access should only see export
    if (timelineStatus !== _timeline.TimelineStatusEnum.immutable) {
      return ['export', 'selectable'];
    }
    return [];
  }, [onCreateRule, onCreateRuleFromEql, timelineStatus, onDeleteSelected, deleteTimelines, timelinePrivileges]);
  const SearchRowContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, templateTimelineFilter), [templateTimelineFilter]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_export_timeline.EditTimelineActions, {
    deleteTimelines: deleteTimelines,
    ids: actionItemId,
    savedSearchIds: actionItemSavedSearchId,
    isDeleteTimelineModalOpen: isDeleteTimelineModalOpen,
    isEnableDownloader: isEnableDownloader,
    onComplete: onCompleteEditTimelineAction,
    title: (_actionItem$title = actionItem === null || actionItem === void 0 ? void 0 : actionItem.title) !== null && _actionItem$title !== void 0 ? _actionItem$title : i18n.UNTITLED_TIMELINE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_import_data_modal.ImportDataModal, {
    isModalVisible: importDataModalToggle !== null && importDataModalToggle !== void 0 ? importDataModalToggle : false,
    closeModal: handleCloseModal,
    title: i18n.IMPORT_TIMELINE,
    filePickerPrompt: i18n.INITIAL_PROMPT_TEXT,
    description: i18n.SELECT_TIMELINE,
    submitBtnText: i18n.IMPORT_TIMELINE_BTN_TITLE,
    errorMessage: i18n.IMPORT_FAILED,
    importData: _api.importTimelines,
    onImportComplete: handleComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "timelines-page-container",
    className: _helpers.OPEN_TIMELINE_CLASS_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, !!timelineFilter && timelineFilter, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_row.SearchRow, {
    "data-test-subj": "search-row",
    favoriteCount: favoriteCount,
    onlyFavorites: onlyFavorites,
    onQueryChange: onQueryChange,
    onToggleOnlyFavorites: onToggleOnlyFavorites,
    query: query,
    timelineType: timelineType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 13
    }
  }, SearchRowContent), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    "data-test-subj": "query-message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SHOWING, ' ', timelineType === _timeline.TimelineTypeEnum.template ? nTemplates : nTimelines))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  }, timelineStatus !== _timeline.TimelineStatusEnum.immutable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    "data-test-subj": "selected-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 23
    }
  }, timelineType === _timeline.TimelineTypeEnum.template ? i18n.SELECTED_TEMPLATES((selectedItems || []).length) : i18n.SELECTED_TIMELINES((selectedItems || []).length)), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "batchActions",
    iconSide: "right",
    iconType: "arrowDown",
    popoverContent: getBatchItemsPopoverContent,
    "data-test-subj": "utility-bar-action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "utility-bar-action-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 25
    }
  }, i18n.BATCH_ACTIONS))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "refreshButton",
    iconSide: "right",
    iconType: "refresh",
    onClick: onRefreshBtnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 19
    }
  }, i18n.REFRESH)))), /*#__PURE__*/_react.default.createElement(_timelines_table.TimelinesTable, {
    actionTimelineToShow: actionTimelineToShow,
    "data-test-subj": "timelines-table",
    deleteTimelines: deleteTimelines,
    defaultPageSize: defaultPageSize,
    loading: isLoading,
    itemIdToExpandedNotesRowMap: itemIdToExpandedNotesRowMap,
    enableExportTimelineDownloader: enableExportTimelineDownloader,
    onCreateRule: onCreateRule,
    onCreateRuleFromEql: onCreateRuleFromEql,
    onOpenDeleteTimelineModal: onOpenDeleteTimelineModal,
    onOpenTimeline: onOpenTimeline,
    onSelectionChange: onSelectionChange,
    onTableChange: onTableChange,
    onToggleShowNotes: onToggleShowNotes,
    pageIndex: pageIndex,
    pageSize: pageSize,
    searchResults: searchResults,
    showExtendedColumns: true,
    sortDirection: sortDirection,
    sortField: sortField,
    timelineType: timelineType,
    totalSearchResultsCount: totalSearchResultsCount,
    tableRef: tableRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  }))));
});
OpenTimeline.displayName = 'OpenTimeline';