"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteNote = useDeleteNote;
var _reactRedux = require("react-redux");
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../../../../common/lib/kibana");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _app = require("../../../../../common/store/app");
var _store = require("../../../../store");
var _timeline = require("../../../../../../common/types/timeline");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteNote(noteId, eventId, eventIdToNoteIds, savedObjectId) {
  const {
    services: {
      http
    }
  } = (0, _kibana.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useMutation)({
    mutationFn: id => {
      return http.fetch('/api/note', {
        method: 'DELETE',
        body: JSON.stringify({
          noteId: id
        }),
        version: '2023-10-31'
      });
    },
    onSuccess: () => {
      const notes = eventIdToNoteIds === null || eventIdToNoteIds === void 0 ? void 0 : eventIdToNoteIds[eventId !== null && eventId !== void 0 ? eventId : ''];
      if (savedObjectId) {
        dispatch(_app.appActions.deleteNote({
          id: savedObjectId
        }));
      }
      if (noteId && eventId) {
        dispatch(_store.timelineActions.deleteNoteFromEvent({
          id: _timeline.TimelineId.active,
          noteId,
          eventId
        }));
      }
      if (eventId && notes && notes.length === 1) {
        dispatch(_store.timelineActions.unPinEvent({
          eventId,
          id: _timeline.TimelineId.active
        }));
      }
    },
    onError: err => {
      addError(err, {
        title: i18n.DELETE_NOTE_ERROR(err)
      });
    }
  });
}