"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteTimelineModalOverlay = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = require("styled-components");
var _reactRouterDom = require("react-router-dom");
var _delete_timeline_modal = require("./delete_timeline_modal");
var _timeline = require("../../../../../common/api/timeline");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/delete_timeline_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RemovePopover = (0, _styledComponents.createGlobalStyle)`
div[data-popover-open] {
  display: none;
}
`;
/**
 * Renders a button that when clicked, displays the `Delete Timeline` modal
 */
const DeleteTimelineModalOverlay = exports.DeleteTimelineModalOverlay = /*#__PURE__*/_react.default.memo(({
  deleteTimelines,
  isModalOpen,
  savedObjectIds,
  title,
  onComplete,
  savedSearchIds
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    tabName: timelineType
  } = (0, _reactRouterDom.useParams)();
  const internalCloseModal = (0, _react.useCallback)(() => {
    if (onComplete != null) {
      onComplete();
    }
  }, [onComplete]);
  const onDelete = (0, _react.useCallback)(() => {
    if (savedObjectIds.length > 0 && savedSearchIds != null && savedSearchIds.length > 0) {
      deleteTimelines(savedObjectIds, savedSearchIds);
      addSuccess({
        title: timelineType === _timeline.TimelineTypeEnum.template ? i18n.SUCCESSFULLY_DELETED_TIMELINE_TEMPLATES(savedObjectIds.length) : i18n.SUCCESSFULLY_DELETED_TIMELINES(savedObjectIds.length)
      });
    } else if (savedObjectIds.length > 0) {
      deleteTimelines(savedObjectIds);
      addSuccess({
        title: timelineType === _timeline.TimelineTypeEnum.template ? i18n.SUCCESSFULLY_DELETED_TIMELINE_TEMPLATES(savedObjectIds.length) : i18n.SUCCESSFULLY_DELETED_TIMELINES(savedObjectIds.length)
      });
    }
    if (onComplete != null) {
      onComplete();
    }
  }, [deleteTimelines, savedObjectIds, onComplete, addSuccess, timelineType, savedSearchIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalOpen && /*#__PURE__*/_react.default.createElement(RemovePopover, {
    "data-test-subj": "remove-popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 25
    }
  }), isModalOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: _delete_timeline_modal.DELETE_TIMELINE_MODAL_WIDTH,
    onClose: internalCloseModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_delete_timeline_modal.DeleteTimelineModal, {
    "data-test-subj": "delete-timeline-modal",
    onDelete: onDelete,
    title: title,
    closeModal: internalCloseModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })) : null);
});
DeleteTimelineModalOverlay.displayName = 'DeleteTimelineModalOverlay';