"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOU_ARE_VIEWING_NOTES = exports.YOU_ARE_EDITING_A_NOTE = exports.SEARCH_PLACEHOLDER = exports.NOTES = exports.NOTE = exports.CANCEL = exports.ADD_NOTE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_NOTE = exports.ADD_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.addNoteButtonLabel', {
  defaultMessage: 'Add Note'
});
const NOTE = exports.NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.noteLabel', {
  defaultMessage: 'Note'
});
const NOTES = exports.NOTES = _i18n.i18n.translate('xpack.securitySolution.notes.notesTitle', {
  defaultMessage: 'Notes'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.notes.search.FilterByUserOrNotePlaceholder', {
  defaultMessage: 'Filter by User or Note'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.notes.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const YOU_ARE_EDITING_A_NOTE = exports.YOU_ARE_EDITING_A_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.youAreEditingANoteScreenReaderOnly', {
  defaultMessage: 'You are editing a note. Click Add Note when finished, or press escape to cancel.'
});
const YOU_ARE_VIEWING_NOTES = row => _i18n.i18n.translate('xpack.securitySolution.notes.youAreViewingNotesScreenReaderOnly', {
  values: {
    row
  },
  defaultMessage: 'You are viewing notes for the event in row {row}. Press the up arrow key when finished to return to the event.'
});
exports.YOU_ARE_VIEWING_NOTES = YOU_ARE_VIEWING_NOTES;