"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewNote = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _markdown_editor = require("../../../../common/components/markdown_editor");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/notes/add_note/new_note.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NewNoteTabs = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 100%;
`;
NewNoteTabs.displayName = 'NewNoteTabs';

/** An input for entering a new note  */
const NewNote = exports.NewNote = /*#__PURE__*/_react.default.memo(({
  note,
  noteInputHeight,
  updateNewNote,
  autoFocusDisabled = false,
  setIsMarkdownInvalid
}) => {
  return /*#__PURE__*/_react.default.createElement(NewNoteTabs, {
    "data-test-subj": "new-note-tabs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownEditor, {
    ariaLabel: i18n.NOTE,
    onChange: updateNewNote,
    value: note,
    dataTestSubj: "add-a-note",
    height: noteInputHeight,
    autoFocusDisabled: autoFocusDisabled,
    setIsMarkdownInvalid: setIsMarkdownInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
});
NewNote.displayName = 'NewNote';