"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineBottomBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var i18n = _interopRequireWildcard(require("./translations"));
var _selectors = require("../../store/selectors");
var _add_timeline_button = require("./add_timeline_button");
var _store = require("../../store");
var _save_status = require("../save_status");
var _add_to_favorites = require("../add_to_favorites");
var _events_count = _interopRequireDefault(require("../timeline/tabs/query/events_count"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/bottom_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This component renders the bottom bar for timeline displayed or most of the pages within Security Solution.
 */
const TimelineBottomBar = exports.TimelineBottomBar = /*#__PURE__*/_react.default.memo(({
  show,
  timelineId,
  openToggleRef
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const openTimeline = (0, _react.useCallback)(() => dispatch(_store.timelineActions.showTimeline({
    id: timelineId,
    show: true
  })), [dispatch, timelineId]);
  const title = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTitleByTimelineById)(state, timelineId));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    hasShadow: false,
    "data-test-subj": "timeline-bottom-bar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_timeline_button.AddTimelineButton, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_to_favorites.AddToFavoritesButton, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": i18n.OPEN_TIMELINE_BUTTON(title),
    onClick: openTimeline,
    "data-test-subj": "timeline-bottom-bar-title-button",
    ref: openToggleRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, title)), !show &&
  /*#__PURE__*/
  // We only want to show this when the timeline modal is closed
  _react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "timeline-event-count-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_events_count.default, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_save_status.TimelineSaveStatus, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }))));
});
TimelineBottomBar.displayName = 'TimelineBottomBar';