"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FILTER_OUT_TITLE = exports.FILTER_OUT_ANNOUNCEMENT = exports.FILTER_IN_ANNOUNCEMENT = exports.FILTER_FOR_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_FOR_TITLE = exports.FILTER_FOR_TITLE = _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.queryBar.filterFor', {
  defaultMessage: 'Filter for'
});
const FILTER_OUT_TITLE = exports.FILTER_OUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.queryBar.filterOut', {
  defaultMessage: 'Filter out'
});
const FILTER_OUT_ANNOUNCEMENT = (field, value) => _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.queryBar.filterOutAnnouncement', {
  defaultMessage: 'Filter applied excluding entries where {field} is {value}. Chart updated',
  values: {
    field,
    value
  }
});
exports.FILTER_OUT_ANNOUNCEMENT = FILTER_OUT_ANNOUNCEMENT;
const FILTER_IN_ANNOUNCEMENT = (field, value) => _i18n.i18n.translate('xpack.securitySolution.threatIntelligence.queryBar.filterInAnnouncement', {
  defaultMessage: 'Filter applied showing only entries where {field} is {value}. Chart updated',
  values: {
    field,
    value
  }
});
exports.FILTER_IN_ANNOUNCEMENT = FILTER_IN_ANNOUNCEMENT;