"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignalHelpers = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _constants = require("../../data_view_manager/constants");
var _store = require("../store");
var _ = require(".");
var _use_data_view = require("../../common/containers/source/use_data_view");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _kibana = require("../../common/lib/kibana");
var _create_sourcerer_data_view = require("./create_sourcerer_data_view");
var _use_data_view2 = require("../../data_view_manager/hooks/use_data_view");
var _use_signal_index_name = require("../../data_view_manager/hooks/use_signal_index_name");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSignalHelpers = () => {
  var _experimentalDefaultD, _experimentalDefaultD2;
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    indicesExist,
    dataViewId: oldDataViewId
  } = (0, _.useSourcererDataView)(_constants.PageScope.alerts);
  const {
    indexFieldsSearch
  } = (0, _use_data_view.useDataView)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const {
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const signalIndexNameSourcerer = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const experimentalSignalIndexName = (0, _use_signal_index_name.useSignalIndexName)();
  const oldDefaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const signalIndexName = newDataViewPickerEnabled ? experimentalSignalIndexName : signalIndexNameSourcerer;
  const {
    dataView: experimentalDefaultDataView,
    status
  } = (0, _use_data_view2.useDataView)(_constants.PageScope.alerts);
  const dataViewId = newDataViewPickerEnabled ? (_experimentalDefaultD = experimentalDefaultDataView === null || experimentalDefaultDataView === void 0 ? void 0 : experimentalDefaultDataView.id) !== null && _experimentalDefaultD !== void 0 ? _experimentalDefaultD : null : oldDataViewId;
  const defaultDataViewPattern = newDataViewPickerEnabled ? (_experimentalDefaultD2 = experimentalDefaultDataView.getIndexPattern()) !== null && _experimentalDefaultD2 !== void 0 ? _experimentalDefaultD2 : '' : oldDefaultDataView.title;
  const signalIndexNeedsInit = (0, _react.useMemo)(() => {
    if (newDataViewPickerEnabled && status === 'pristine') {
      return false;
    }
    return !defaultDataViewPattern.includes(`${signalIndexName}`);
  }, [defaultDataViewPattern, newDataViewPickerEnabled, signalIndexName, status]);
  const shouldWePollForIndex = (0, _react.useMemo)(() => !indicesExist && !signalIndexNeedsInit, [indicesExist, signalIndexNeedsInit]);
  const pollForSignalIndex = (0, _react.useCallback)(() => {
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      try {
        const sourcererDataView = await (0, _create_sourcerer_data_view.createSourcererDataView)({
          dataViewService: dataViews,
          defaultDetails: {
            dataViewId,
            patternList: defaultDataViewPattern.split(',')
          },
          alertDetails: {}
        });
        if (signalIndexName !== null && sourcererDataView !== null && sourcererDataView !== void 0 && sourcererDataView.defaultDataView.patternList.includes(signalIndexName)) {
          // first time signals is defined and validated in the sourcerer
          // redo indexFieldsSearch
          indexFieldsSearch({
            dataViewId: sourcererDataView.defaultDataView.id
          });
          dispatch(_store.sourcererActions.setSourcererDataViews(sourcererDataView));
        }
      } catch (err) {
        if (err.name === 'AbortError') {
          // the fetch was canceled, we don't need to do anything about it
        } else {
          addError(err, {
            title: _i18n.i18n.translate('xpack.securitySolution.sourcerer.error.title', {
              defaultMessage: 'Error updating Security Data View'
            }),
            toastMessage: _i18n.i18n.translate('xpack.securitySolution.sourcerer.error.toastMessage', {
              defaultMessage: 'Refresh the page'
            })
          });
        }
      }
    };
    if (signalIndexName !== null) {
      abortCtrl.current.abort();
      asyncSearch();
    }
  }, [addError, dataViewId, dataViews, defaultDataViewPattern, dispatch, indexFieldsSearch, signalIndexName]);
  return {
    ...(shouldWePollForIndex ? {
      pollForSignalIndex
    } : {}),
    signalIndexNeedsInit
  };
};
exports.useSignalHelpers = useSignalHelpers;