"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourcererPaths = exports.showSourcererByPath = exports.getScopeFromPath = void 0;
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../data_view_manager/constants");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourcererPaths = exports.sourcererPaths = [_constants2.ALERTS_PATH, _constants2.DATA_QUALITY_PATH, `${_constants2.RULES_PATH}/id/:id`, _constants2.HOSTS_PATH, _constants2.USERS_PATH, _constants2.NETWORK_PATH, _constants2.OVERVIEW_PATH, _constants2.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH];
const detectionsPaths = [_constants2.ALERTS_PATH, `${_constants2.RULES_PATH}/id/:id`, `${_constants2.CASES_PATH}/:detailName`, _constants2.ATTACK_DISCOVERY_PATH];
const attacksPaths = [_constants2.ATTACKS_PATH];
const explorePaths = [_constants2.HOSTS_PATH, _constants2.USERS_PATH, _constants2.NETWORK_PATH, _constants2.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH, _constants2.ENTITY_ANALYTICS_MANAGEMENT_PATH];
const getScopeFromPath = (pathname, newDataViewPickerEnabled) => {
  if ((0, _reactRouterDom.matchPath)(pathname, {
    path: detectionsPaths,
    strict: false
  })) {
    return _constants.PageScope.alerts;
  }
  if (newDataViewPickerEnabled && (0, _reactRouterDom.matchPath)(pathname, {
    path: attacksPaths,
    strict: false
  })) {
    return _constants.PageScope.attacks;
  }
  if (newDataViewPickerEnabled && (0, _reactRouterDom.matchPath)(pathname, {
    path: explorePaths,
    strict: false
  })) {
    return _constants.PageScope.explore;
  }
  return _constants.PageScope.default;
};
exports.getScopeFromPath = getScopeFromPath;
const showSourcererByPath = pathname => (0, _reactRouterDom.matchPath)(pathname, {
  path: sourcererPaths,
  strict: false
}) != null;
exports.showSourcererByPath = showSourcererByPath;