"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStatusColumn = exports.SIEM_MIGRATIONS_STATUS_HEADER_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _status_badge = require("../status_badge");
var _components = require("../../../common/components");
var _utils = require("../../../common/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table_columns/status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SIEM_MIGRATIONS_STATUS_HEADER_ID = exports.SIEM_MIGRATIONS_STATUS_HEADER_ID = 'siemMigrationsStatusHeader';
const createStatusColumn = () => {
  return {
    field: 'translation_result',
    name: /*#__PURE__*/_react.default.createElement(_components.TableHeader, {
      id: SIEM_MIGRATIONS_STATUS_HEADER_ID,
      title: i18n.COLUMN_STATUS,
      tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.rules.tableColumn.statusTooltip",
        defaultMessage: `{title}
            {installed} - already added to Elastic SIEM. Click "View" to manage and enable it.{lineBreak}
            {translated} - ready to install. This rule was mapped to an Elastic Authored rule if possible, or translated by AI.{lineBreak}
            {partiallyTranslated} - part of the query could not be translated. Upload any missing macros or lookups and check your syntax.{lineBreak}
            {notTranslated} - none of the original query could be translated.`,
        values: {
          lineBreak: /*#__PURE__*/_react.default.createElement("br", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 37,
              columnNumber: 26
            }
          }),
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 39,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 40,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 41,
              columnNumber: 21
            }
          }, i18n.STATUS_TOOLTIP_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            margin: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 42,
              columnNumber: 21
            }
          }))),
          installed: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 46,
              columnNumber: 26
            }
          }, i18n.INSTALLED_STATUS_TITLE),
          translated: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 48,
              columnNumber: 17
            }
          }, (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.FULL)),
          partiallyTranslated: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 51,
              columnNumber: 17
            }
          }, (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.PARTIAL)),
          notTranslated: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 54,
              columnNumber: 17
            }
          }, (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.UNTRANSLATABLE))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 7
      }
    }),
    render: (_, rule) => {
      var _rule$translation_res;
      return /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
        "data-test-subj": `translationStatus-${(_rule$translation_res = rule.translation_result) !== null && _rule$translation_res !== void 0 ? _rule$translation_res : rule.status}`,
        migrationRule: rule,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 7
        }
      });
    },
    sortable: true,
    truncateText: true,
    width: '15%'
  };
};
exports.createStatusColumn = createStatusColumn;