"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlEditorField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/esql/public");
var _convert_to_query_type = require("../../../../../../../../common/components/query_bar/convert_to_query_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rule_details_flyout/tabs/translation/query_details/esql_editor/esql_editor_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATA_ERRORS_STORAGE_KEY = 'siemMigrations_esqlEditorDataErrorsEnabled';
const EsqlEditorField = exports.EsqlEditorField = /*#__PURE__*/_react.default.memo(({
  field,
  idAria,
  dataTestSubj
}) => {
  const {
    value: fieldValue,
    setValue: setFieldValue
  } = field;
  const [isDataErrorsEnabled, setIsDataErrorsEnabled] = (0, _useLocalStorage.default)(DATA_ERRORS_STORAGE_KEY, true);
  const dataErrorsControl = (0, _react.useMemo)(() => ({
    enabled: isDataErrorsEnabled !== null && isDataErrorsEnabled !== void 0 ? isDataErrorsEnabled : true,
    onChange: setIsDataErrorsEnabled
  }), [isDataErrorsEnabled, setIsDataErrorsEnabled]);
  const query = (0, _react.useMemo)(() => ({
    esql: fieldValue.query.query
  }), [fieldValue.query.query]);
  const onQueryChange = (0, _react.useCallback)(newQuery => {
    if (!(0, _fastDeepEqual.default)(fieldValue.query, newQuery)) {
      const esqlQuery = (0, _convert_to_query_type.convertToQueryType)(newQuery);
      setFieldValue({
        ...fieldValue,
        query: esqlQuery
      });
    }
  }, [fieldValue, setFieldValue]);
  const onQuerySubmit = (0, _react.useCallback)(async newQuery => {
    if (newQuery) {
      onQueryChange(newQuery);
    }
  }, [onQueryChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ESQLLangEditor, {
    query: query,
    onTextLangQueryChange: onQueryChange,
    onTextLangQuerySubmit: onQuerySubmit,
    dataErrorsControl: dataErrorsControl,
    hideRunQueryText: true,
    disableSubmitAction: true,
    hideTimeFilterInfo: true,
    hideQueryHistory: true,
    hasOutline: true,
    editorIsInline: true,
    hideRunQueryButton: true,
    expandToFitQueryOnMount: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }));
});
EsqlEditorField.displayName = 'EsqlEditorField';