"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationsUploadMissingPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _panel_text = require("../../../../common/components/panel_text");
var i18n = _interopRequireWildcard(require("./translations"));
var _migration_data_input_flyout_context = require("../../../common/components/migration_data_input_flyout_context");
var _use_get_missing_resources = require("../../../common/hooks/use_get_missing_resources");
var _use_kibana = require("../../../../common/lib/kibana/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/migration_status_panels/upload_missing_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardMigrationsUploadMissingPanel = exports.DashboardMigrationsUploadMissingPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  topSpacerSize
}) => {
  const [missingResources, setMissingResources] = (0, _react.useState)([]);
  const {
    getMissingResources,
    isLoading
  } = (0, _use_get_missing_resources.useGetMissingResources)('dashboard', setMissingResources);
  (0, _react.useEffect)(() => {
    getMissingResources(migrationStats.id);
  }, [getMissingResources, migrationStats.id]);
  if (isLoading || missingResources.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(DashboardMigrationsUploadMissingPanelContent, {
    migrationStats: migrationStats,
    topSpacerSize: topSpacerSize,
    missingResources: missingResources,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  });
});
DashboardMigrationsUploadMissingPanel.displayName = 'DashboardMigrationsUploadMissingPanel';
const DashboardMigrationsUploadMissingPanelContent = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  topSpacerSize,
  missingResources
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    openFlyout
  } = (0, _migration_data_input_flyout_context.useMigrationDataInputContext)();
  const {
    telemetry
  } = (0, _use_kibana.useKibana)().services.siemMigrations.dashboards;
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout(migrationStats);
    telemetry.reportSetupMigrationOpenResources({
      migrationId: migrationStats.id,
      missingResourcesCount: missingResources.length
    });
  }, [migrationStats, openFlyout, telemetry, missingResources.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, topSpacerSize && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: topSpacerSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    css: {
      backgroundColor: euiTheme.colors.backgroundBasePrimary
    },
    "data-test-subj": "uploadMissingPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    "data-test-subj": "uploadMissingPanelTitle",
    size: "s",
    semiBold: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  }, i18n.DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    "data-test-subj": "uploadMissingPanelDescription",
    size: "s",
    subdued: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  }, i18n.DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: onOpenFlyout,
    iconType: "download",
    iconSide: "right",
    size: "s",
    "data-test-subj": "uploadMissingPanelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }, i18n.DASHBOARD_MIGRATION_UPLOAD_BUTTON)))));
});
DashboardMigrationsUploadMissingPanelContent.displayName = 'DashboardMigrationsUploadMissingPanelContent';