"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingLookupsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/migration_steps/lookups/missing_lookups_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const scrollPanelCss = (0, _css.css)`
  max-height: 200px;
  overflow-y: auto;
`;
const MissingLookupsList = exports.MissingLookupsList = /*#__PURE__*/_react.default.memo(({
  missingLookups,
  uploadedLookups,
  omitLookup,
  onCopied
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.common.dataInputFlyout.lookups.copyExportQuery.description",
    defaultMessage: "Log in to your Splunk admin account, go to the {app}, download the following lookups individually and upload them below. You can also omit lookups that are empty or not needed, and they will be ignored in the translation.",
    values: {
      app: /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 30
        }
      }, i18n.LOOKUPS_SPLUNK_APP)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: scrollPanelCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }, missingLookups.map(lookupName => {
    const isOmitted = uploadedLookups[lookupName] === '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: lookupName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexStart",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 23
      }
    }, uploadedLookups[lookupName] != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: euiTheme.colors.success,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 27
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      style: isOmitted ? {
        textDecoration: 'line-through'
      } : {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 25
      }
    }, lookupName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: lookupName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 25
      }
    }, copy => /*#__PURE__*/_react.default.createElement(CopyLookupNameButton, {
      lookupName: lookupName,
      onCopied: onCopied,
      copy: copy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 29
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(OmitLookupButton, {
      lookupName: lookupName,
      omitLookup: omitLookup,
      isDisabled: isOmitted,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 25
      }
    }))));
  })))));
});
MissingLookupsList.displayName = 'MissingLookupsList';
const CopyLookupNameButton = /*#__PURE__*/_react.default.memo(({
  lookupName,
  onCopied,
  copy
}) => {
  const onClick = (0, _react.useCallback)(() => {
    copy();
    onCopied();
  }, [copy, onCopied]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.COPY_LOOKUP_NAME_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onClick,
    iconType: "copy",
    color: "text",
    "aria-label": `${i18n.COPY_LOOKUP_NAME_TOOLTIP} ${lookupName}`,
    "data-test-subj": "lookupNameCopy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }));
});
CopyLookupNameButton.displayName = 'CopyLookupNameButton';
const OmitLookupButton = /*#__PURE__*/_react.default.memo(({
  lookupName,
  omitLookup,
  isDisabled: isDisabledDefault
}) => {
  const [isDisabled, setIsDisabled] = (0, _react.useState)(isDisabledDefault);
  const onClick = (0, _react.useCallback)(() => {
    setIsDisabled(true);
    omitLookup(lookupName);
  }, [omitLookup, lookupName]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onClick,
    iconType: "cross",
    color: "text",
    "aria-label": i18n.CLEAR_EMPTY_LOOKUP_TOOLTIP,
    "data-test-subj": "lookupNameClear",
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }), [onClick, isDisabled]);
  if (isDisabled) {
    return button;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CLEAR_EMPTY_LOOKUP_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 12
    }
  }, button);
});
OmitLookupButton.displayName = 'OmitLookupButton';