"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RENAME_MIGRATION_TEXT = exports.OPEN_MIGRATION_OPTIONS_BUTTON = exports.NOT_DELETABLE_MIGRATION_TEXT = exports.MIGRATION_TRANSLATING = exports.MIGRATION_STOP_BUTTON = exports.MIGRATION_STOPPING_BUTTON = exports.MIGRATION_PROGRESS_DESCRIPTION = exports.MIGRATION_PREPARING = exports.MIGRATION_ERROR_TITLE = exports.DELETE_MIGRATION_TITLE = exports.DELETE_MIGRATION_TEXT = exports.DELETE_MIGRATION_DESCRIPTION = exports.DELETE_BUTTON_TEXT = exports.CANCEL_DELETE_MIGRATION_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Common translations for all migration panels
const OPEN_MIGRATION_OPTIONS_BUTTON = exports.OPEN_MIGRATION_OPTIONS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.openMigrationOptionsButton', {
  defaultMessage: 'Open migration options'
});
const RENAME_MIGRATION_TEXT = exports.RENAME_MIGRATION_TEXT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.renameMigrationText', {
  defaultMessage: 'Rename'
});
const DELETE_BUTTON_TEXT = exports.DELETE_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.deleteButtonText', {
  defaultMessage: 'Delete'
});
const DELETE_MIGRATION_TEXT = exports.DELETE_MIGRATION_TEXT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.deleteMigrationText', {
  defaultMessage: 'Delete Migration'
});
const NOT_DELETABLE_MIGRATION_TEXT = exports.NOT_DELETABLE_MIGRATION_TEXT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.notDeletableMigrationText', {
  defaultMessage: 'Can not delete running migrations'
});
const CANCEL_DELETE_MIGRATION_TEXT = exports.CANCEL_DELETE_MIGRATION_TEXT = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.cancelDeleteMigrationText', {
  defaultMessage: 'Cancel'
});
const DELETE_MIGRATION_TITLE = exports.DELETE_MIGRATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.delete.title', {
  defaultMessage: 'Are you sure you want to delete this migration?'
});
const DELETE_MIGRATION_DESCRIPTION = exports.DELETE_MIGRATION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.delete.description', {
  defaultMessage: 'This action cannot be undone. All translations related to this migration will be removed permanently.'
});

// Progress panel translations
const MIGRATION_PROGRESS_DESCRIPTION = totalItems => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.progress.description', {
  defaultMessage: `Processing migration of {totalItems} items.`,
  values: {
    totalItems
  }
});
exports.MIGRATION_PROGRESS_DESCRIPTION = MIGRATION_PROGRESS_DESCRIPTION;
const MIGRATION_PREPARING = exports.MIGRATION_PREPARING = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.progress.preparing', {
  defaultMessage: `Preparing environment for the AI powered translation.`
});
const MIGRATION_TRANSLATING = exports.MIGRATION_TRANSLATING = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.progress.translating', {
  defaultMessage: `Translating items`
});
const MIGRATION_STOP_BUTTON = exports.MIGRATION_STOP_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.translate.stopButton', {
  defaultMessage: 'Stop'
});
const MIGRATION_STOPPING_BUTTON = exports.MIGRATION_STOPPING_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.translate.stoppingButton', {
  defaultMessage: 'Stopping'
});

// Error panel translations
const MIGRATION_ERROR_TITLE = exports.MIGRATION_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.panels.error', {
  defaultMessage: 'The last execution of this migration failed with the following message:'
});