"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeSubMenuComponents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_colors = require("./use_colors");
var _use_link_props = require("./use_link_props");
var _side_effect_context = require("./side_effect_context");
var _formatted_number = require("../../common/components/formatted_number");
var _actions = require("../store/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/submenu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A Submenu that displays a collection of "pills" for each related event
 * category it has events for.
 */
// eslint-disable-next-line react/display-name
const NodeSubMenuComponents = exports.NodeSubMenuComponents = /*#__PURE__*/_react.default.memo(({
  id,
  className,
  nodeID,
  nodeStats,
  onClick
}) => {
  const relatedEventOptions = (0, _react.useMemo)(() => {
    if (nodeStats === undefined) {
      return [];
    } else {
      return Object.entries(nodeStats.byCategory).map(([category, total]) => {
        const prefix = /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
          count: total || 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 26
          }
        });
        return {
          prefix,
          category
        };
      });
    }
  }, [nodeStats]);
  if (relatedEventOptions === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("ul", {
    className: `${className} options`,
    "aria-describedby": nodeID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, relatedEventOptions.sort((opta, optb) => {
    return opta.category.localeCompare(optb.category);
  }).map(pill => {
    return /*#__PURE__*/_react.default.createElement(NodeSubmenuPill, {
      id: id,
      pill: pill,
      nodeID: nodeID,
      key: pill.category,
      onClick: onClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 15
      }
    });
  }));
});
const NodeSubmenuPill = ({
  id,
  pill,
  nodeID,
  onClick
}) => {
  const linkProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEventsInCategory',
    panelParameters: {
      nodeID,
      eventCategory: pill.category
    }
  });
  const {
    pillStroke: pillBorderStroke,
    resolverBackground: pillFill
  } = (0, _use_colors.useColors)();
  const listStylesFromTheme = (0, _react.useMemo)(() => {
    return {
      border: `1.5px solid ${pillBorderStroke}`,
      backgroundColor: pillFill
    };
  }, [pillBorderStroke, pillFill]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timestamp
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const handleOnClick = (0, _react.useCallback)(mouseEvent => {
    linkProps.onClick(mouseEvent);
    dispatch((0, _actions.userSelectedResolverNode)({
      id,
      nodeID,
      time: timestamp()
    }));
    // onClick call back to open the details panel
    // only used when in split mode
    if (onClick) {
      onClick();
    }
  }, [timestamp, linkProps, dispatch, nodeID, id, onClick]);
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "item",
    "data-test-subj": "resolver:map:node-submenu-item",
    style: listStylesFromTheme,
    key: pill.category,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: "kbn-resetFocusState",
    onClick: handleOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, pill.prefix, " ", pill.category));
};