"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _panels = require("./panels");
var _resolver_no_process_events = require("./resolver_no_process_events");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/details_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Details panel component
 */
const DetailsPanelComponent = /*#__PURE__*/_react.default.memo(({
  resolverComponentInstanceID,
  nodeEventOnClick
}) => {
  const isLoading = (0, _reactRedux.useSelector)(state => selectors.isTreeLoading(state.analyzer[resolverComponentInstanceID]));
  const hasError = (0, _reactRedux.useSelector)(state => selectors.hadErrorLoadingTree(state.analyzer[resolverComponentInstanceID]));
  const resolverTreeHasNodes = (0, _reactRedux.useSelector)(state => selectors.resolverTreeHasNodes(state.analyzer[resolverComponentInstanceID]));
  return isLoading ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:panel:loading",
    className: "loading-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })) : hasError ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:panel:error",
    className: "loading-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.loadingError",
    defaultMessage: "Error loading data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))) : resolverTreeHasNodes ? /*#__PURE__*/_react.default.createElement(_panels.PanelRouter, {
    id: resolverComponentInstanceID,
    nodeEventOnClick: nodeEventOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_resolver_no_process_events.ResolverNoProcessEvents, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  });
});
DetailsPanelComponent.displayName = 'DetailsPanelComponent';

/**
 * Stand alone details panel to be used when in split panel mode
 */
const DetailsPanel = exports.DetailsPanel = /*#__PURE__*/_react.default.memo(({
  resolverComponentInstanceID,
  nodeEventOnClick
}) => {
  const isAnalyzerInitialized = (0, _reactRedux.useSelector)(state => Boolean(state.analyzer[resolverComponentInstanceID]));
  return isAnalyzerInitialized ? /*#__PURE__*/_react.default.createElement(DetailsPanelComponent, {
    resolverComponentInstanceID: resolverComponentInstanceID,
    nodeEventOnClick: nodeEventOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:panel:loading",
    className: "loading-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }));
});
DetailsPanel.displayName = 'DetailsPanel';