"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userSelectedResolverNode = exports.userRequestedRelatedEventData = exports.userFocusedOnResolverNode = exports.createResolver = exports.clearResolver = exports.appReceivedNewExternalProperties = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/security_solution/analyzer');
const createResolver = exports.createResolver = actionCreator('CREATE_RESOLVER');
const clearResolver = exports.clearResolver = actionCreator('CLEAR_RESOLVER');

/**
 * The action dispatched when the app requests related event data for one
 * subject (whose entity_id should be included as `payload`)
 */
const userRequestedRelatedEventData = exports.userRequestedRelatedEventData = actionCreator('REQUEST_RELATED_EVENT');

/**
 * When the user switches the "active descendant" of the Resolver.
 * The "active descendant" (from the point of view of the parent element)
 * corresponds to the "current" child element. "active" or "current" here meaning
 * the element that is focused on by the user's interactions with the UI, but
 * not necessarily "selected" (see UserSelectedResolverNode below)
 */
const userFocusedOnResolverNode = exports.userFocusedOnResolverNode = actionCreator('FOCUS_ON_NODE');

/**
 * When the user "selects" a node in the Resolver
 * "Selected" refers to the state of being the element that the
 * user most recently "picked" (by e.g. pressing a button corresponding
 * to the element in a list) as opposed to "active" or "current" (see UserFocusedOnResolverNode above).
 */
const userSelectedResolverNode = exports.userSelectedResolverNode = actionCreator('SELECT_RESOLVER_NODE');

/**
 * Used by `useStateSyncingActions` hook.
 * This is dispatched when external sources provide new parameters for Resolver.
 * When the component receives a new 'databaseDocumentID' prop, this is fired.
 */
const appReceivedNewExternalProperties = exports.appReceivedNewExternalProperties = actionCreator('APP_RECEIVED_NEW_EXTERNAL_PROPERTIES');