"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignalIndexWithDefault = void 0;
var _react = require("react");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_space_id = require("../../common/hooks/use_space_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSignalIndexWithDefault = () => {
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const alertsIndex = (0, _react.useMemo)(() => {
    return signalIndexName !== null && signalIndexName !== void 0 ? signalIndexName : `.alerts-security.alerts-${spaceId}`;
  }, [signalIndexName, spaceId]);
  return alertsIndex;
};
exports.useSignalIndexWithDefault = useSignalIndexWithDefault;