"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertFilteringMetric = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _constants = require("../../../data_view_manager/constants");
var _use_signal_index_with_default = require("../../hooks/use_signal_index_with_default");
var _utils = require("./utils");
var _types = require("../../../common/components/visualization_actions/types");
var _alert_filtering_metric = require("../../../common/components/visualization_actions/lens_attributes/ai/alert_filtering_metric");
var i18n = _interopRequireWildcard(require("./translations"));
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/alert_filtering_metric.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = 'AlertFilteringMetricQuery';
const AlertFilteringMetricComponent = ({
  attackAlertIds,
  from,
  to,
  totalAlerts
}) => {
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    filters: (0, _utils.getExcludeAlertsFilters)(attackAlertIds)
  }), [attackAlertIds]);
  const signalIndexName = (0, _use_signal_index_with_default.useSignalIndexWithDefault)();
  const getLensAttributes = (0, _react.useCallback)(args => (0, _alert_filtering_metric.getAlertFilteringMetricLensAttributes)({
    ...args,
    signalIndexName,
    totalAlerts
  }), [signalIndexName, totalAlerts]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        height: 100%;
        > * {
          height: 100% !important;
        }
        .echMetricText__icon .euiIcon {
          fill: ${colors.vis.euiColorVis4};
        }
        .echMetricText {
          padding: 8px 16px 60px;
        }
        .echMetricText {
          display: grid !important;
          grid-template-columns: auto auto 1fr !important;
          gap: 8px !important;
          align-items: center !important;
        }
        .echMetricText__titlesBlock--left {
          grid-column: 1 !important;
        }
        .echMetricText__icon--right {
          grid-column: 2 !important;
        }
        .euiPanel,
        .embPanel,
        .echMetric,
        .echChartBackground,
        .embPanel__hoverActions > span {
          background-color: rgb(0, 0, 0, 0) !important;
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "alert-filtering-metric",
    extraOptions: extraVisualizationOptions,
    getLensAttributes: getLensAttributes,
    timerange: {
      from,
      to
    },
    id: `${ID}-area-embeddable`,
    inspectTitle: i18n.FILTERING_RATE,
    scopeId: _constants.PageScope.alerts,
    withActions: [_types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.inspect],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }));
};
const AlertFilteringMetric = exports.AlertFilteringMetric = /*#__PURE__*/_react.default.memo(AlertFilteringMetricComponent);