"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserOverview = exports.USER_OVERVIEW_RISK_SCORE_QUERY_ID = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _search_strategy = require("../../../../common/search_strategy");
var _risk_score_header_title = require("../../../entity_analytics/components/risk_score_header_title");
var _use_global_time = require("../../../common/containers/use_global_time");
var _common = require("../../../entity_analytics/common");
var _manage_query = require("../../../common/components/page/manage_query");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _types = require("../../../../common/entity_analytics/types");
var _empty_value = require("../../../common/components/empty_value");
var _default_renderer = require("../../../timelines/components/field_renderers/default_renderer");
var _first_last_seen = require("../../../common/components/first_last_seen/first_last_seen");
var _inspect = require("../../../common/components/inspect");
var _loader = require("../../../common/components/loader");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _anomaly_scores = require("../../../common/components/ml/score/anomaly_scores");
var _page = require("../../../common/components/page");
var _flyout_link = require("../../../flyout/shared/components/flyout_link");
var i18n = _interopRequireWildcard(require("./translations"));
var _overview_description_list = require("../../../common/components/overview_description_list");
var _common2 = require("../../../entity_analytics/components/severity/common");
var _common3 = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/user_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UserRiskOverviewWrapper = (0, _styled.default)(_eui.EuiFlexGroup, {
  shouldForwardProp: prop => prop !== '$width'
})`
  padding-top: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
  width: ${({
  $width
}) => $width};
`;
const USER_OVERVIEW_RISK_SCORE_QUERY_ID = exports.USER_OVERVIEW_RISK_SCORE_QUERY_ID = 'riskInputsTabQuery';
const UserOverview = exports.UserOverview = /*#__PURE__*/_react.default.memo(({
  anomaliesData,
  contextID,
  scopeId,
  data,
  id,
  isInDetailsSidePanel = false,
  // Rather than duplicate the component, alter the structure based on it's location
  isLoadingAnomaliesData,
  loading,
  narrowDateRange,
  startDate,
  endDate,
  userName,
  indexPatterns,
  jobNameById,
  isFlyoutOpen = false
}) => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const userPermissions = (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities);
  const darkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const filterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    data: userRisk,
    isAuthorized,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    refetch: refetchRiskScore
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    skip: userName == null,
    riskEntity: _types.EntityType.user,
    onlyLatest: false,
    pagination: _common.FIRST_RECORD_PAGINATION
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    queryId: USER_OVERVIEW_RISK_SCORE_QUERY_ID,
    refetch: refetchRiskScore,
    setQuery
  });
  const getDefaultRenderer = (0, _react.useCallback)((fieldName, fieldData) => /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
    rowItems: (0, _fp.getOr)([], fieldName, fieldData),
    attrName: fieldName,
    idPrefix: contextID ? `user-overview-${contextID}` : 'user-overview',
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), [contextID, scopeId]);
  const [userRiskScore, userRiskLevel] = (0, _react.useMemo)(() => {
    const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
        title: i18n.USER_RISK_SCORE,
        riskScoreEntity: _types.EntityType.user,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 13
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? Math.round(userRiskData.user.risk.calculated_score_norm) : (0, _empty_value.getEmptyTagValue)())
    }, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
        title: i18n.USER_RISK_LEVEL,
        riskScoreEntity: _types.EntityType.user,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_common3.RiskScoreDocTooltip, {
        anchorPosition: "upCenter",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 17
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? /*#__PURE__*/_react.default.createElement(_common2.RiskScoreLevel, {
        severity: userRiskData.user.risk.calculated_level,
        hideBackgroundColor: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 17
        }
      }) : (0, _empty_value.getEmptyTagValue)())
    }];
  }, [userRisk]);
  const column = (0, _react.useMemo)(() => [{
    title: i18n.USER_ID,
    description: data && data.user ? getDefaultRenderer('user.id', data) : (0, _empty_value.getEmptyTagValue)()
  }, {
    title: i18n.USER_DOMAIN,
    description: data && data.user ? getDefaultRenderer('user.domain', data) : (0, _empty_value.getEmptyTagValue)()
  }], [data, getDefaultRenderer]);
  const firstColumn = (0, _react.useMemo)(() => userPermissions ? [...column, {
    title: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    description: /*#__PURE__*/_react.default.createElement(_anomaly_scores.AnomalyScores, {
      anomalies: anomaliesData,
      startDate: startDate,
      endDate: endDate,
      isLoading: isLoadingAnomaliesData,
      narrowDateRange: narrowDateRange,
      jobNameById: jobNameById,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 19
      }
    })
  }] : column, [anomaliesData, column, endDate, isLoadingAnomaliesData, narrowDateRange, startDate, userPermissions, jobNameById]);
  const descriptionLists = (0, _react.useMemo)(() => [firstColumn, [{
    title: i18n.FIRST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: 'user.name',
      value: userName,
      type: _first_last_seen.FirstLastSeenType.FIRST_SEEN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 15
      }
    })
  }, {
    title: i18n.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: 'user.name',
      value: userName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 15
      }
    })
  }], [{
    title: i18n.HOST_OS,
    description: getDefaultRenderer('host.os.name', data)
  }, {
    title: i18n.HOST_FAMILY,
    description: getDefaultRenderer('host.os.family', data)
  }, {
    title: i18n.HOST_IP,
    description: /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
      rowItems: (0, _fp.getOr)([], 'host.ip', data),
      attrName: 'host.ip',
      idPrefix: contextID ? `user-overview-${contextID}` : 'user-overview',
      scopeId: scopeId,
      render: ip => ip != null ? /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
        field: 'host.ip',
        value: ip,
        scopeId: scopeId,
        isFlyoutOpen: isFlyoutOpen,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 21
        }
      }) : (0, _empty_value.getEmptyTagValue)(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 15
      }
    })
  }]], [data, indexPatterns, getDefaultRenderer, contextID, scopeId, userName, firstColumn, isFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_page.OverviewWrapper, {
    direction: isInDetailsSidePanel ? 'column' : 'row',
    "data-test-subj": "user-overview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 11
    }
  }, !isInDetailsSidePanel && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: id,
    title: i18n.INSPECT_TITLE,
    inspectIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }), descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    descriptionList: descriptionList,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 15
    }
  })), loading && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    overlayBackground: darkMode ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }))), isAuthorized && /*#__PURE__*/_react.default.createElement(UserRiskOverviewWrapper, {
    gutterSize: isInDetailsSidePanel ? 'm' : 'none',
    direction: isInDetailsSidePanel ? 'column' : 'row',
    "data-test-subj": "user-risk-overview",
    $width: isInDetailsSidePanel ? '100%' : '66.6%',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: [userRiskScore],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: [userRiskLevel],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 15
    }
  }))));
});
UserOverview.displayName = 'UserOverview';