"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentCases = void 0;
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_CASES_TO_SHOW = 3;
const RecentCasesComponent = () => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  return cases.ui.getRecentCases({
    permissions: userCasesPermissions,
    maxCasesToShow: MAX_CASES_TO_SHOW,
    owner: [_constants.APP_ID]
  });
};
RecentCasesComponent.displayName = 'RecentCasesComponent';
const RecentCases = exports.RecentCases = /*#__PURE__*/_react.default.memo(RecentCasesComponent);