"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointOverview = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _agent_status = require("../../../../common/components/endpoint/agents/agent_status");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _empty_value = require("../../../../common/components/empty_value");
var _default_renderer = require("../../../../timelines/components/field_renderers/default_renderer");
var i18n = _interopRequireWildcard(require("./translations"));
var _hosts = require("../../../../../common/search_strategy/security_solution/hosts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/host_overview/endpoint_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointOverview = exports.EndpointOverview = /*#__PURE__*/_react.default.memo(({
  contextID,
  data,
  scopeId
}) => {
  const getDefaultRenderer = (0, _react.useCallback)((fieldName, fieldData, attrName) => /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
    rowItems: [(0, _fp.getOr)('', fieldName, fieldData)],
    attrName: attrName,
    idPrefix: contextID ? `endpoint-overview-${contextID}` : 'endpoint-overview',
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), [contextID, scopeId]);
  const descriptionLists = (0, _react.useMemo)(() => {
    var _data$hostInfo, _appliedPolicy$name, _data$hostInfo2;
    const appliedPolicy = data === null || data === void 0 ? void 0 : (_data$hostInfo = data.hostInfo) === null || _data$hostInfo === void 0 ? void 0 : _data$hostInfo.metadata.Endpoint.policy.applied;
    return [[{
      title: i18n.ENDPOINT_POLICY,
      description: (_appliedPolicy$name = appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.name) !== null && _appliedPolicy$name !== void 0 ? _appliedPolicy$name : (0, _empty_value.getEmptyTagValue)()
    }], [{
      title: i18n.POLICY_STATUS,
      description: appliedPolicy !== null && appliedPolicy !== void 0 && appliedPolicy.status ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        "aria-label": appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status,
        color: (appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status) === _hosts.HostPolicyResponseActionStatus.failure ? 'danger' : appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }, appliedPolicy === null || appliedPolicy === void 0 ? void 0 : appliedPolicy.status) : (0, _empty_value.getEmptyTagValue)()
    }], [{
      title: i18n.SENSORVERSION,
      description: data !== null && data !== void 0 && (_data$hostInfo2 = data.hostInfo) !== null && _data$hostInfo2 !== void 0 && _data$hostInfo2.metadata.agent.version ? getDefaultRenderer('hostInfo.metadata.agent.version', data, 'agent.version') : (0, _empty_value.getEmptyTagValue)()
    }], [{
      title: i18n.FLEET_AGENT_STATUS,
      description: data != null && data.hostInfo ? /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
        agentId: data.hostInfo.metadata.agent.id,
        agentType: "endpoint",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 15
        }
      }) : (0, _empty_value.getEmptyTagValue)()
    }]];
  }, [data, getDefaultRenderer]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: "endpoint-overview",
    descriptionList: descriptionList,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })));
});
EndpointOverview.displayName = 'EndpointOverview';