"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SocTrends = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _constants = require("../../../../common/store/inputs/constants");
var _date_picker_lock = require("./date_picker_lock");
var _super_date_picker = require("../../../../common/components/super_date_picker");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _header_section = require("../../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_soc_trends = require("./hooks/use_soc_trends");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/soc_trends/soc_trends.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SOC_TRENDS_ID = 'socTrends';
const StyledEuiPanel = (0, _styled.default)(_eui.EuiPanel)`
  min-width: 300px;
`;
const StyledEuiFlexGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  max-width: 300px;
`;
const getListItem = stat => ({
  title: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: stat.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, stat.title, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 24
    }
  })))),
  description: stat.isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": `${stat.testRef}-stat-loading-spinner`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stat.stat, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: stat.percentage.note,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: stat.percentage.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, stat.percentage.percent != null ? stat.percentage.percent : '-')))
});
const SocTrendsComponent = ({
  signalIndexName
}) => {
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(SOC_TRENDS_ID);
  const {
    stats,
    latestUpdate,
    isUpdating
  } = (0, _use_soc_trends.useSocTrends)({
    skip: !toggleStatus,
    signalIndexName
  });
  const listItems = (0, _react.useMemo)(() => stats.map(stat => getListItem(stat)), [stats]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: SOC_TRENDS_ID,
    showInspectButton: false,
    stackHeader: true,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: latestUpdate,
      isUpdating: isUpdating,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 19
      }
    }),
    title: i18n.SOC_TRENDS,
    titleSize: "s",
    toggleQuery: setToggleStatus,
    toggleStatus: toggleStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
    id: _constants.InputsModelId.socTrends,
    showUpdateButton: "iconOnly",
    width: "auto",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_date_picker_lock.SocTrendsDatePickerLock, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  })))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": 'statsList',
    textStyle: "reverse",
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }))));
};
const SocTrends = exports.SocTrends = /*#__PURE__*/_react.default.memo(SocTrendsComponent);