"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SocTrendsDatePickerLock = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _constants = require("../../../../../common/store/inputs/constants");
var _inputs = require("../../../../../common/store/inputs");
var _use_selector = require("../../../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/soc_trends/date_picker_lock/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SocTrendsDatePickerLockComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalInput = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalSelector(), []);
  const isDatePickerLocked = (0, _use_selector.useShallowEqualSelector)(state => getGlobalInput(state).linkTo.includes(_constants.InputsModelId.socTrends));
  const onToggleLock = (0, _react.useCallback)(() => dispatch(_inputs.inputsActions.toggleSocTrendsLinkTo()), [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "socTrends-date-picker-lock-tooltip",
    position: "top",
    content: isDatePickerLocked ? i18n.LOCK_SYNC_MAIN_DATE_PICKER_TOOL_TIP : i18n.UNLOCK_SYNC_MAIN_DATE_PICKER_TOOL_TIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `socTrends-date-picker-${isDatePickerLocked ? 'lock' : 'unlock'}-button`,
    color: "primary",
    onClick: onToggleLock,
    iconType: isDatePickerLocked ? 'lock' : 'lockOpen',
    "aria-label": isDatePickerLocked ? i18n.UNLOCK_SYNC_MAIN_DATE_PICKER_ARIA : i18n.LOCK_SYNC_MAIN_DATE_PICKER_ARIA,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
SocTrendsDatePickerLockComponent.displayName = 'SocTrendsDatePickerLockComponent';
const SocTrendsDatePickerLock = exports.SocTrendsDatePickerLock = /*#__PURE__*/_react.default.memo(SocTrendsDatePickerLockComponent);