"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StartMigrationCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _missing_privileges = require("../../../../../../../common/components/missing_privileges");
var _use_upselling = require("../../../../../../../common/hooks/use_upselling");
var _panel_text = require("../../../../../../../common/components/panel_text");
var _data_input_wrapper = require("../../../../../../../siem_migrations/rules/components/data_input_flyout/data_input_wrapper");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
var _constants2 = require("../../../../../../constants");
var _use_latest_stats = require("../../../../../../../siem_migrations/rules/service/hooks/use_latest_stats");
var _centered_loading_spinner = require("../../../../../../../common/components/centered_loading_spinner");
var _card_content_panel = require("../../../common/card_content_panel");
var _rule_migrations_panels = require("./rule_migrations_panels");
var _start_migration_card = require("../common/start_migration_card.styles");
var _upload_rules_panel = require("./upload_rules_panel");
var _translations = require("../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/siem_migrations/start_migration/rules/start_migration_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StartMigrationsBody = /*#__PURE__*/_react.default.memo(({
  setComplete,
  isCardComplete,
  setExpandedCardId,
  checkComplete
}) => {
  const styles = (0, _start_migration_card.useStyles)();
  const {
    data: migrationsStats,
    isLoading,
    refreshStats
  } = (0, _use_latest_stats.useLatestStats)();
  (0, _react.useEffect)(() => {
    // Set card complete if any migration is finished
    if (!isCardComplete(_constants2.OnboardingCardId.siemMigrationsRules) && migrationsStats) {
      if (migrationsStats.some(({
        status
      }) => status === _constants.SiemMigrationTaskStatus.FINISHED)) {
        setComplete(true);
      }
    }
  }, [isCardComplete, migrationsStats, setComplete]);
  const isConnectorsCardComplete = (0, _react.useMemo)(() => isCardComplete(_constants2.OnboardingCardId.siemMigrationsAiConnectors), [isCardComplete]);
  const expandConnectorsCard = (0, _react.useCallback)(() => {
    setExpandedCardId(_constants2.OnboardingCardId.siemMigrationsAiConnectors);
  }, [setExpandedCardId]);
  const onFlyoutClosed = (0, _react.useCallback)(() => {
    refreshStats();
    checkComplete();
  }, [refreshStats, checkComplete]);
  return /*#__PURE__*/_react.default.createElement(_data_input_wrapper.RuleMigrationDataInputWrapper, {
    onFlyoutClosed: onFlyoutClosed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    "data-test-subj": "StartMigrationsCardBody",
    className: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_rule_migrations_panels.RuleMigrationsPanels, {
    migrationsStats: migrationsStats,
    isConnectorsCardComplete: isConnectorsCardComplete,
    expandConnectorsCard: expandConnectorsCard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "xs",
    subdued: true,
    cursive: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, _translations.START_MIGRATION_CARD_FOOTER_NOTE))));
});
StartMigrationsBody.displayName = 'StartMigrationsBody';
const StartMigrationCard = exports.StartMigrationCard = /*#__PURE__*/_react.default.memo(({
  checkCompleteMetadata,
  ...props
}) => {
  const UpsellSectionComp = (0, _use_upselling.useUpsellingComponent)('siem_migrations_start');
  if (!checkCompleteMetadata) {
    return /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 14
      }
    });
  }
  if (UpsellSectionComp) {
    return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(UpsellSectionComp, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_upload_rules_panel.UploadRulesSectionPanel, {
      isUploadMore: false,
      isDisabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }))));
  }
  const {
    missingCapabilities
  } = checkCompleteMetadata;
  if (missingCapabilities.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_missing_privileges.BasicMissingPrivilegesCallOut, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesDescription, {
      privileges: missingCapabilities,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(StartMigrationsBody, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 12
    }
  }));
});
StartMigrationCard.displayName = 'StartMigrationCard';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = StartMigrationCard;