"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstalledPackages = exports.getCompleteBadgeText = exports.getAgentsData = exports.getActiveIntegrationList = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PER_PAGE = 100;
const getCompleteBadgeText = installedCount => _i18n.i18n.translate('xpack.securitySolution.onboarding.integrationsCard.badge.completeText', {
  defaultMessage: '{count} {count, plural, one {integration} other {integrations}} added',
  values: {
    count: installedCount
  }
});
exports.getCompleteBadgeText = getCompleteBadgeText;
const getInstalledPackages = async ({
  showOnlyActiveDataStreams,
  perPage,
  searchAfter
}, services) => {
  return services.http.get(`${_public.EPM_API_ROUTES.INSTALLED_LIST_PATTERN}`, {
    version: '2023-10-31',
    query: {
      showOnlyActiveDataStreams,
      perPage,
      searchAfter: searchAfter ? JSON.stringify(searchAfter) : undefined
    }
  }).catch(err => {
    const emptyItems = [];
    services.notifications.toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.integrationsCard.checkComplete.fetchIntegrations.errorTitle', {
        defaultMessage: 'Error fetching integrations data'
      })
    });
    return {
      items: emptyItems,
      total: 0,
      searchAfter: undefined
    };
  });
};
exports.getInstalledPackages = getInstalledPackages;
const getActiveIntegrationList = async (services, availableIntegrationNames) => {
  var _activePackageData$it, _activePackageData$it2;
  const params = {
    showOnlyActiveDataStreams: true,
    perPage: PER_PAGE,
    searchAfter: undefined
  };
  const activePackageData = {
    items: [],
    total: 0
  };
  while (true) {
    var _activePackageRespons;
    const activePackageResponse = await getInstalledPackages(params, services);
    params.searchAfter = activePackageResponse.searchAfter;
    activePackageData.items.push(...activePackageResponse.items);
    activePackageData.total = activePackageResponse.total;
    if (activePackageData.items.length === activePackageResponse.total || !(activePackageResponse !== null && activePackageResponse !== void 0 && (_activePackageRespons = activePackageResponse.items) !== null && _activePackageRespons !== void 0 && _activePackageRespons.length) || !(activePackageResponse !== null && activePackageResponse !== void 0 && activePackageResponse.searchAfter)) {
      break;
    }
  }
  const activePackages = (_activePackageData$it = activePackageData === null || activePackageData === void 0 ? void 0 : (_activePackageData$it2 = activePackageData.items) === null || _activePackageData$it2 === void 0 ? void 0 : _activePackageData$it2.filter(installedPkg => {
    const isInstalled = (installedPkg.status === _public.installationStatuses.Installed || installedPkg.status === _public.installationStatuses.InstallFailed) && installedPkg.dataStreams.length > 0;
    return availableIntegrationNames ? isInstalled && availableIntegrationNames.some(availableIntegration => availableIntegration === installedPkg.name) : isInstalled;
  })) !== null && _activePackageData$it !== void 0 ? _activePackageData$it : [];
  const isComplete = activePackages && activePackages.length > 0;
  return {
    isComplete,
    activePackages
  };
};
exports.getActiveIntegrationList = getActiveIntegrationList;
const getAgentsData = async (services, isComplete) => {
  var _agentsData$rawRespon, _agentsData$rawRespon2;
  const agentsData = await (0, _rxjs.lastValueFrom)(services.data.search.search({
    params: {
      index: _constants.AGENT_INDEX,
      body: {
        size: 1
      }
    }
  })).catch(err => {
    services.notifications.toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.integrationsCard.checkComplete.fetchAgents.errorTitle', {
        defaultMessage: 'Error fetching agents data'
      })
    });
    return {
      rawResponse: {
        hits: {
          total: 0
        }
      }
    };
  });
  const agentsDataAvailable = !!(agentsData !== null && agentsData !== void 0 && (_agentsData$rawRespon = agentsData.rawResponse) !== null && _agentsData$rawRespon !== void 0 && (_agentsData$rawRespon2 = _agentsData$rawRespon.hits) !== null && _agentsData$rawRespon2 !== void 0 && _agentsData$rawRespon2.total);
  // If the integration card is complete (has one active integration), we don't need to check for agents data
  const isAgentRequired = !isComplete && !agentsDataAvailable;
  return {
    isAgentRequired,
    agentsData
  };
};
exports.getAgentsData = getAgentsData;