"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = exports.links = {
  id: _constants.SecurityPageName.notes,
  path: _constants.NOTES_PATH,
  title: _translations.NOTES,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.notesDescription', {
    defaultMessage: 'Oversee, revise, and revisit the notes attached to alerts, events and Timelines.'
  }),
  // It only makes sense to show this link when the user is also granted access to security solution
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.NOTES_FEATURE_ID}.read`]],
  landingIcon: 'filebeatApp',
  skipUrlState: true,
  hideTimeline: false
};