"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USING_ADVANCED_MODE_DESCRIPTION = exports.USING_ADVANCED_MODE = exports.TRUSTED_APPLICATIONS = exports.SELECT_OS_LABEL = exports.PROCESS_DESCENDANTS_TRUSTED_APP = exports.POLICY_SELECT_DESCRIPTION = exports.OPERATOR_TITLES = exports.NAME_LABEL = exports.INPUT_ERRORS = exports.ENTRY_PROPERTY_TITLES = exports.DETAILS_HEADER_DESCRIPTION = exports.DETAILS_HEADER = exports.DESCRIPTION_LABEL = exports.CONDITION_FIELD_TITLE = exports.CONDITION_FIELD_DESCRIPTION = exports.CONDITIONS_HEADER_DESCRIPTION = exports.CONDITIONS_HEADER = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedApps.name.label', {
  defaultMessage: 'Name'
});
const DETAILS_HEADER = exports.DETAILS_HEADER = _i18n.i18n.translate('xpack.securitySolution.trustedApps.details.header', {
  defaultMessage: 'Details'
});
const DETAILS_HEADER_DESCRIPTION = exports.DETAILS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.details.header.description', {
  defaultMessage: 'Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts. Trusted applications may still generate alerts in some cases.'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.description', {
  defaultMessage: 'Description'
});
const CONDITIONS_HEADER = exports.CONDITIONS_HEADER = _i18n.i18n.translate('xpack.securitySolution.trustedApps.conditions.header', {
  defaultMessage: 'Conditions'
});
const CONDITIONS_HEADER_DESCRIPTION = exports.CONDITIONS_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.conditions.header.description', {
  defaultMessage: 'Select either Basic or Advanced mode to add a trusted application. Then, select an operating system and add conditions. Availability of conditions may depend on your chosen operating system.'
});
const USING_ADVANCED_MODE = exports.USING_ADVANCED_MODE = _i18n.i18n.translate('xpack.securitySolution.trustedApps.conditions.header.description.advancedMode', {
  defaultMessage: 'You are using advanced mode.'
});
const USING_ADVANCED_MODE_DESCRIPTION = exports.USING_ADVANCED_MODE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.conditions.header.description.advancedMode2', {
  defaultMessage: 'While advanced Trusted Application configuration allows for more complex conditions, use caution. Overly broad conditions can expose your systems to risk.'
});
const SELECT_OS_LABEL = exports.SELECT_OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.trustedApps.os.label', {
  defaultMessage: 'Select operating system'
});
const PROCESS_DESCENDANTS_TRUSTED_APP = exports.PROCESS_DESCENDANTS_TRUSTED_APP = _i18n.i18n.translate('xpack.securitySolution.trustedApps.processDescendants.label', {
  defaultMessage: 'Process Descendants'
});
const TRUSTED_APPLICATIONS = exports.TRUSTED_APPLICATIONS = _i18n.i18n.translate('xpack.securitySolution.trustedApps.processDescendants.label', {
  defaultMessage: 'Trusted Applications'
});
const CONDITION_FIELD_TITLE = exports.CONDITION_FIELD_TITLE = {
  [_securitysolutionUtils.ConditionEntryField.HASH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.hash', {
    defaultMessage: 'Hash'
  }),
  [_securitysolutionUtils.ConditionEntryField.PATH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.path', {
    defaultMessage: 'Path'
  }),
  [_securitysolutionUtils.ConditionEntryField.SIGNER]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.signature', {
    defaultMessage: 'Signature'
  }),
  [_securitysolutionUtils.ConditionEntryField.SIGNER_MAC]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.signatureMac', {
    defaultMessage: 'Signature'
  })
};
const CONDITION_FIELD_DESCRIPTION = exports.CONDITION_FIELD_DESCRIPTION = {
  [_securitysolutionUtils.ConditionEntryField.HASH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.hash', {
    defaultMessage: 'md5, sha1, or sha256'
  }),
  [_securitysolutionUtils.ConditionEntryField.PATH]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.path', {
    defaultMessage: 'The full path of the application'
  }),
  [_securitysolutionUtils.ConditionEntryField.SIGNER]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.signature', {
    defaultMessage: 'The signer of the application'
  }),
  [_securitysolutionUtils.ConditionEntryField.SIGNER_MAC]: _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.field.description.signatureMac', {
    defaultMessage: 'The signer of the application'
  })
};
const OPERATOR_TITLES = exports.OPERATOR_TITLES = {
  is: _i18n.i18n.translate('xpack.securitySolution.trustedapps.card.operator.is', {
    defaultMessage: 'is'
  }),
  matches: _i18n.i18n.translate('xpack.securitySolution.trustedapps.card.operator.matches', {
    defaultMessage: 'matches'
  })
};
const ENTRY_PROPERTY_TITLES = exports.ENTRY_PROPERTY_TITLES = {
  field: _i18n.i18n.translate('xpack.securitySolution.trustedapps.trustedapp.entry.field', {
    defaultMessage: 'Field'
  }),
  operator: _i18n.i18n.translate('xpack.securitySolution.trustedapps.trustedapp.entry.operator', {
    defaultMessage: 'Operator'
  }),
  value: _i18n.i18n.translate('xpack.securitySolution.trustedapps.trustedapp.entry.value', {
    defaultMessage: 'Value'
  })
};
const POLICY_SELECT_DESCRIPTION = exports.POLICY_SELECT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.trustedApps.assignmentSectionDescription', {
  defaultMessage: 'Assign this trusted application globally across all policies, or assign it to specific policies.'
});
const INPUT_ERRORS = exports.INPUT_ERRORS = {
  name: _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.nameRequiredMsg', {
    defaultMessage: 'Name is required'
  }),
  os: _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.osRequiredMsg', {
    defaultMessage: 'Operating System is required'
  }),
  field: _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionRequiredMsg', {
    defaultMessage: 'At least one Field definition is required'
  }),
  noDuplicateField: field => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldDuplicatedMsg', {
    defaultMessage: '{field} cannot be added more than once',
    values: {
      field: CONDITION_FIELD_TITLE[field]
    }
  }),
  mustHaveValue: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldValueRequiredMsg', {
    defaultMessage: '[{row}] Field entry must have a value',
    values: {
      row: index + 1
    }
  }),
  invalidHash: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldInvalidHashMsg', {
    defaultMessage: '[{row}] Invalid hash value',
    values: {
      row: index + 1
    }
  }),
  pathWarning: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldInvalidPathMsg', {
    defaultMessage: '[{row}] Path may be formed incorrectly; verify value',
    values: {
      row: index + 1
    }
  }),
  wildcardPathWarning: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionFieldDegradedPerformanceMsg', {
    defaultMessage: `[{row}] A wildcard in the filename will affect the endpoint's performance`,
    values: {
      row: index + 1
    }
  }),
  wildcardWithWrongOperatorWarning: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionWrongOperatorMsg', {
    defaultMessage: `[{row}] Using a "*" or a "?" in the value with the "is" operator can make the entry ineffective. Change the operator to "matches" to ensure wildcards run properly.`,
    values: {
      row: index + 1
    }
  }),
  wildcardWithWrongField: index => _i18n.i18n.translate('xpack.securitySolution.trustedapps.create.conditionWrongFieldMsg', {
    defaultMessage: `[{row}] Wildcards (? or *) are not supported for hash or signature entries.`,
    values: {
      row: index + 1
    }
  })
};