"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateValues = exports.TrustedAppsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _public = require("@kbn/lists-plugin/public");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../../common/lib/kibana");
var _artifacts = require("../../../../hooks/artifacts");
var _use_suggestions = require("../../../../hooks/use_suggestions");
var _source = require("../../../../../common/containers/source");
var _constants = require("../../../../../../common/endpoint/constants");
var _formatted_error = require("../../../../components/formatted_error");
var _validations = require("../../../../../../common/endpoint/service/artifacts/validations");
var _type_guards = require("../../state/type_guards");
var _translations = require("../translations");
var _translations2 = require("../../../../common/translations");
var _logical_condition = require("./logical_condition");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _show_value_list_modal = require("../../../../../value_list/components/show_value_list_modal");
var _artifacts_docs_link = require("./artifacts_docs_link");
var _utils = require("../../../../../../common/endpoint/service/artifacts/utils");
var _constants2 = require("../../../../../../common/endpoint/service/artifacts/constants");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _service = require("../../service");
var _constants3 = require("../../constants");
var _loader = require("../../../../../common/components/loader");
var _utils2 = require("../../../../common/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/trusted_apps/view/components/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const addResultToValidation = (validation, field, type, resultValue, addToFront) => {
  if (!validation.result[field]) {
    validation.result[field] = {
      isInvalid: false,
      errors: [],
      warnings: []
    };
  }
  const errorMarkup = type === 'warnings' ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 62
    }
  }, resultValue) : resultValue;
  if (addToFront) {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    validation.result[field][type].unshift(errorMarkup);
  } else {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    validation.result[field][type].push(errorMarkup);
  }
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  validation.result[field].isInvalid = true;
};
const validateValues = values => {
  var _ref, _values$os_types;
  let isValid = true;
  const validation = {
    isValid,
    result: {}
  };
  let extraWarning;

  // Name field
  if (!values.name.trim()) {
    isValid = false;
    addResultToValidation(validation, 'name', 'errors', _translations.INPUT_ERRORS.name);
  }
  if (!values.os_types) {
    isValid = false;
    addResultToValidation(validation, 'os', 'errors', _translations.INPUT_ERRORS.os);
  }
  const os = (_ref = ((_values$os_types = values.os_types) !== null && _values$os_types !== void 0 ? _values$os_types : [])[0]) !== null && _ref !== void 0 ? _ref : _securitysolutionUtils.OperatingSystem.WINDOWS;
  if ((0, _utils.isAdvancedModeEnabled)(values) && values.entries.some(e => e.type !== 'nested' && (e.value === '' || !e.value.length))) {
    isValid = false;
  }
  if (!values.entries.length) {
    isValid = false;
    addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.field);
  } else if (!(0, _utils.isAdvancedModeEnabled)(values)) {
    const duplicated = (0, _validations.getDuplicateFields)(values.entries);
    if (duplicated.length) {
      isValid = false;
      duplicated.forEach(field => {
        addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.noDuplicateField(field));
      });
    }
    values.entries.forEach((entry, index) => {
      const isValidPathEntry = (0, _securitysolutionUtils.isPathValid)({
        os,
        field: entry.field,
        type: entry.type,
        value: entry.value
      });
      if ((0, _securitysolutionUtils.validateHasWildcardWithWrongOperator)({
        operator: entry.type,
        value: entry.value
      })) {
        if (entry.field === _securitysolutionUtils.ConditionEntryField.PATH) {
          extraWarning = true;
          addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.wildcardWithWrongOperatorWarning(index));
        } else {
          addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.wildcardWithWrongField(index));
        }
      }
      if (!entry.field || !entry.value.trim()) {
        isValid = false;
        addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.mustHaveValue(index));
      } else if (entry.field === _securitysolutionUtils.ConditionEntryField.HASH && !(0, _validations.isValidHash)(entry.value)) {
        isValid = false;
        addResultToValidation(validation, 'entries', 'errors', _translations.INPUT_ERRORS.invalidHash(index));
      } else if (!isValidPathEntry) {
        addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.pathWarning(index));
      } else if (isValidPathEntry && !(0, _securitysolutionUtils.hasSimpleExecutableName)({
        os,
        value: entry.value,
        type: entry.type
      })) {
        if (entry.type === 'wildcard') {
          addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.wildcardPathWarning(index));
        } else {
          addResultToValidation(validation, 'entries', 'warnings', _translations.INPUT_ERRORS.pathWarning(index));
        }
      }
    });
  }
  if (extraWarning) {
    addResultToValidation(validation, 'entries', 'errors', /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.WildCardWithWrongOperatorCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 9
      }
    })), true);
    validation.extraWarning = extraWarning;
  }
  validation.isValid = isValid;
  return validation;
};
exports.validateValues = validateValues;
const defaultConditionEntry = () => ({
  field: _securitysolutionUtils.ConditionEntryField.HASH,
  operator: 'included',
  type: 'match',
  value: ''
});
const TrustedAppsForm = exports.TrustedAppsForm = /*#__PURE__*/(0, _react.memo)(({
  item,
  onChange,
  mode,
  error: submitError
}) => {
  var _validationResult$res, _validationResult$res2, _validationResult$res3, _validationResult$res4, _validationResult$res5, _validationResult$res6, _validationResult$res7, _validationResult$res8;
  const isTAAdvancedModeFeatureFlagEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('trustedAppsAdvancedMode');
  const isProcessDescendantsFeatureForTrustedAppsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('filterProcessDescendantsForTrustedAppsEnabled');
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)('trustedApps-form');
  const [visited, setVisited] = (0, _react.useState)({});
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  const showAssignmentSection = (0, _artifacts.useCanAssignArtifactPerPolicy)(item, mode, hasFormChanged);
  const isFormAdvancedMode = (0, _react.useMemo)(() => (0, _utils.isAdvancedModeEnabled)(item), [item]);
  const {
    getTagsUpdatedBy
  } = (0, _artifacts.useGetUpdatedTags)(item);
  const [lastBasicFormConditions, setLastBasicFormConditions] = (0, _react.useState)(!isFormAdvancedMode ? item.entries : []);
  const [lastAdvancedFormConditions, setLastAdvancedFormConditions] = (0, _react.useState)(isFormAdvancedMode ? item.entries : []);
  const isProcessDescendantsSelected = (0, _react.useMemo)(() => (0, _utils.isProcessDescendantsEnabled)(item, _constants2.TRUSTED_PROCESS_DESCENDANTS_TAG), [item]);

  // Combine related state into a single object to reduce re-renders
  const [conditionsState, setConditionsState] = (0, _react.useState)({
    areValid: !!item.entries.length,
    hasDuplicateFields: false,
    hasWildcardWithWrongOperator: (0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)([item]),
    hasPartialCodeSignatureWarning: (0, _securitysolutionListUtils.hasPartialCodeSignatureEntry)([item])
  });
  const [validationResult, setValidationResult] = (0, _react.useState)(() => validateValues(item));
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const getSuggestionsFn = (0, _react.useCallback)(({
    field,
    query
  }) => {
    const trustedAppsAPIClient = new _service.TrustedAppsApiClient(http);
    return trustedAppsAPIClient.getSuggestions({
      field: field.name,
      query
    });
  }, [http]);
  const autocompleteSuggestions = (0, _use_suggestions.useSuggestions)(getSuggestionsFn);

  // This value has to be memoized to avoid infinite useEffect loop on useFetchIndex
  const indexNames = (0, _react.useMemo)(() => [_constants.eventsIndexPattern], []);
  const [isIndexPatternLoading, {
    indexPatterns
  }] = (0, _source.useFetchIndex)(indexNames, undefined, _constants.ENDPOINT_FIELDS_SEARCH_STRATEGY);
  const selectedFormType = (0, _react.useMemo)(() => {
    return isFormAdvancedMode ? 'advancedMode' : 'basicMode';
  }, [isFormAdvancedMode]);
  const advancedModeToggle = (0, _react.useMemo)(() => [{
    id: 'basicMode',
    label: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutForm.basicMode', {
      defaultMessage: 'Basic'
    }),
    iconType: selectedFormType === 'basicMode' ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': 'basicModeButton'
  }, {
    id: 'advancedMode',
    label: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutForm.advancedMode', {
      defaultMessage: 'Advanced'
    }),
    iconType: selectedFormType === 'advancedMode' ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': 'advancedModeButton'
  }], [selectedFormType]);

  // Stabilized processChanged callback with minimal dependencies
  const processChanged = (0, _react.useCallback)(updatedFormValues => {
    const updatedItem = updatedFormValues ? {
      ...item,
      ...updatedFormValues
    } : item;
    const updatedValidationResult = validateValues(updatedItem);
    setValidationResult(updatedValidationResult);
    onChange({
      item: updatedItem,
      isValid: updatedValidationResult.isValid && conditionsState.areValid,
      confirmModalLabels: updatedValidationResult.extraWarning ? (0, _translations2.CONFIRM_WARNING_MODAL_LABELS)(_i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutForm.confirmModal.name', {
        defaultMessage: 'trusted application'
      })) : undefined
    });
  }, [conditionsState.areValid, item, onChange]);
  const handleEffectedPolicyOnChange = (0, _react.useCallback)(updatedItem => {
    processChanged(updatedItem);
    setHasFormChanged(true);
  }, [processChanged]);
  const handleOnNameOrDescriptionChange = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      [event.target.name]: event.target.value
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleOnNameBlur = (0, _react.useCallback)(({
    target: {
      name
    }
  }) => {
    processChanged(item);
    setVisited(prevVisited => ({
      ...prevVisited,
      [name]: true
    }));
  }, [item, processChanged]);
  const osOptions = (0, _react.useMemo)(() => [_securitysolutionUtils.OperatingSystem.LINUX, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.WINDOWS].map(os => ({
    value: os,
    inputDisplay: _translations2.OS_TITLES[os]
  })), []);
  const handleAdvancedModeChange = (0, _react.useCallback)(selectedId => {
    // save current form to relevant state before switching
    if (selectedId === 'advancedMode') {
      setLastBasicFormConditions(item.entries);
    } else {
      setLastAdvancedFormConditions(item.entries);
    }
    const nextItem = {
      ...item,
      entries: selectedId === 'advancedMode' ? lastAdvancedFormConditions : lastBasicFormConditions,
      tags: getTagsUpdatedBy('advancedMode', selectedId === 'advancedMode' ? [_constants2.ADVANCED_MODE_TAG] : [])
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [lastAdvancedFormConditions, lastBasicFormConditions, getTagsUpdatedBy, item, processChanged]);
  const handleOnOsChange = (0, _react.useCallback)(os => {
    setVisited(prevVisited => {
      return {
        ...prevVisited,
        os: true
      };
    });
    const nextItem = {
      ...item,
      os_types: [os],
      entries: []
    };
    switch (os) {
      case _securitysolutionUtils.OperatingSystem.LINUX:
        nextItem.entries = item.entries.filter(entry => (0, _type_guards.isSignerFieldExcluded)(entry));
        if (item.entries.length === 0) {
          nextItem.entries.push(defaultConditionEntry());
        }
        break;
      case _securitysolutionUtils.OperatingSystem.MAC:
        nextItem.entries = item.entries.map(entry => entry.field === _securitysolutionUtils.ConditionEntryField.SIGNER ? {
          ...entry,
          field: _securitysolutionUtils.ConditionEntryField.SIGNER_MAC
        } : entry);
        if (item.entries.length === 0) {
          nextItem.entries.push(defaultConditionEntry());
        }
        break;
      case _securitysolutionUtils.OperatingSystem.WINDOWS:
        nextItem.entries = item.entries.map(entry => entry.field === _securitysolutionUtils.ConditionEntryField.SIGNER_MAC ? {
          ...entry,
          field: _securitysolutionUtils.ConditionEntryField.SIGNER
        } : entry);
        if (item.entries.length === 0) {
          nextItem.entries.push(defaultConditionEntry());
        }
        break;
      default:
        nextItem.entries.push(...item.entries);
        break;
    }
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleConditionBuilderOnVisited = (0, _react.useCallback)(() => {
    setVisited(prevState => {
      return {
        ...prevState,
        entries: true
      };
    });
  }, []);
  const handleEntryChange = (0, _react.useCallback)((newEntry, oldEntry) => {
    const nextItem = {
      ...item,
      entries: item.entries.map(e => {
        if (e === oldEntry) {
          return newEntry;
        }
        return e;
      })
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleEntryRemove = (0, _react.useCallback)(entry => {
    const nextItem = {
      ...item,
      entries: item.entries.filter(e => e !== entry)
    };
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const handleAndClick = (0, _react.useCallback)(() => {
    var _ref2, _item$os_types;
    const nextItem = {
      ...item,
      entries: []
    };
    const os = (_ref2 = ((_item$os_types = item.os_types) !== null && _item$os_types !== void 0 ? _item$os_types : [])[0]) !== null && _ref2 !== void 0 ? _ref2 : _securitysolutionUtils.OperatingSystem.WINDOWS;
    if (os === _securitysolutionUtils.OperatingSystem.LINUX) {
      nextItem.entries = [...item.entries.filter(entry => (0, _type_guards.isSignerFieldExcluded)(entry)), defaultConditionEntry()];
    } else {
      nextItem.entries = [...item.entries, defaultConditionEntry()];
    }
    processChanged(nextItem);
    setHasFormChanged(true);
  }, [item, processChanged]);
  const selectedOs = (0, _react.useMemo)(() => {
    var _item$os_types2;
    if (!(item !== null && item !== void 0 && (_item$os_types2 = item.os_types) !== null && _item$os_types2 !== void 0 && _item$os_types2.length)) {
      return _securitysolutionUtils.OperatingSystem.WINDOWS;
    }
    return item.os_types[0];
  }, [item === null || item === void 0 ? void 0 : item.os_types]);
  const trustedApp = (0, _react.useMemo)(() => {
    const ta = item;
    ta.entries = item.entries.length ? item.entries : [defaultConditionEntry()];
    setConditionsState(prev => ({
      ...prev,
      areValid: !!ta.entries.length
    }));
    return ta;
  }, [item]);

  // Stabilized advanced mode conditions handler with proper change detection
  const handleOnBuilderChange = (0, _react.useCallback)(arg => {
    var _arg$exceptionItems, _arg$exceptionItems$, _currentItem$name, _currentItem$descript, _currentItem$comments, _currentItem$os_types, _currentItem$tags;
    // Early return for unnecessary calls to prevent infinite loops
    if (!((_arg$exceptionItems = arg.exceptionItems) !== null && _arg$exceptionItems !== void 0 && _arg$exceptionItems[0]) && !hasFormChanged) {
      return;
    }
    const currentItem = item;
    const newEntries = (_arg$exceptionItems$ = arg.exceptionItems[0]) === null || _arg$exceptionItems$ === void 0 ? void 0 : _arg$exceptionItems$.entries;

    // More robust change detection
    const hasActualChanges = newEntries && (!currentItem.entries || !(0, _lodash.isEqual)(newEntries, currentItem.entries));
    if (!hasActualChanges && hasFormChanged) {
      // Only handle duplicate field detection for unchanged forms
      if (newEntries) {
        const addedFields = newEntries.map(e => e.field) || [''];
        setConditionsState(prev => ({
          ...prev,
          hasDuplicateFields: (0, _utils2.computeHasDuplicateFields)((0, _utils2.getAddedFieldsCounts)(addedFields))
        }));
        return;
      }
    }

    // Batch all condition state updates
    setConditionsState(prev => {
      var _arg$exceptionItems$2, _arg$exceptionItems$3;
      return {
        ...prev,
        hasDuplicateFields: false,
        hasWildcardWithWrongOperator: (0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)(arg.exceptionItems),
        hasPartialCodeSignatureWarning: (0, _securitysolutionListUtils.hasPartialCodeSignatureEntry)(arg.exceptionItems),
        areValid: arg.exceptionItems[0] !== undefined ? !(arg.errorExists && !((_arg$exceptionItems$2 = arg.exceptionItems[0]) !== null && _arg$exceptionItems$2 !== void 0 && (_arg$exceptionItems$3 = _arg$exceptionItems$2.entries) !== null && _arg$exceptionItems$3 !== void 0 && _arg$exceptionItems$3.length)) : false
      };
    });
    const updatedItem = arg.exceptionItems[0] !== undefined ? {
      ...arg.exceptionItems[0],
      name: (_currentItem$name = currentItem === null || currentItem === void 0 ? void 0 : currentItem.name) !== null && _currentItem$name !== void 0 ? _currentItem$name : '',
      description: (_currentItem$descript = currentItem === null || currentItem === void 0 ? void 0 : currentItem.description) !== null && _currentItem$descript !== void 0 ? _currentItem$descript : '',
      comments: (_currentItem$comments = currentItem === null || currentItem === void 0 ? void 0 : currentItem.comments) !== null && _currentItem$comments !== void 0 ? _currentItem$comments : [],
      os_types: (_currentItem$os_types = currentItem === null || currentItem === void 0 ? void 0 : currentItem.os_types) !== null && _currentItem$os_types !== void 0 ? _currentItem$os_types : [_securitysolutionUtils.OperatingSystem.WINDOWS],
      tags: (_currentItem$tags = currentItem === null || currentItem === void 0 ? void 0 : currentItem.tags) !== null && _currentItem$tags !== void 0 ? _currentItem$tags : [],
      meta: currentItem.meta
    } : {
      ...currentItem,
      entries: [{
        field: '',
        operator: 'included',
        type: 'match',
        value: ''
      }]
    };
    processChanged(updatedItem);
    if (!hasFormChanged) {
      setHasFormChanged(true);
    }
  }, [hasFormChanged, processChanged, item]);

  // Stabilized memoization with minimal dependencies
  const exceptionBuilderComponentMemo = (0, _react.useMemo)(() => (0, _public.getExceptionBuilderComponentLazy)({
    allowLargeValueLists: false,
    httpService: http,
    autocompleteService: autocompleteSuggestions,
    exceptionListItems: [trustedApp],
    listType: _constants3.TRUSTED_APPS_LIST_TYPE,
    listId: _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.id,
    listNamespaceType: 'agnostic',
    indexPatterns,
    isOrDisabled: true,
    isOrHidden: true,
    isAndDisabled: false,
    isNestedDisabled: false,
    dataTestSubj: getTestId('exceptionBuilder'),
    idAria: 'alert-exception-builder',
    onChange: handleOnBuilderChange,
    operatorsList: _securitysolutionListUtils.ENDPOINT_ARTIFACT_OPERATORS,
    osTypes: trustedApp.os_types,
    showValueListModal: _show_value_list_modal.ShowValueListModal
  }), [autocompleteSuggestions, getTestId, http, indexPatterns, trustedApp, handleOnBuilderChange]);
  const handleFilterTypeOnChange = (0, _react.useCallback)(id => {
    const newTagsForDescendants = id === 'descendants' ? [_constants2.TRUSTED_PROCESS_DESCENDANTS_TAG] : [];
    const tags = getTagsUpdatedBy('trustedProcessDescendants', newTagsForDescendants);
    processChanged({
      ...item,
      tags
    });
    if (!hasFormChanged) setHasFormChanged(true);
  }, [getTagsUpdatedBy, hasFormChanged, processChanged, item]);
  const filterTypeOptions = (0, _react.useMemo)(() => [{
    id: 'events',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 710,
        columnNumber: 18
      }
    }, _translations.TRUSTED_APPLICATIONS),
    iconType: isProcessDescendantsSelected ? 'empty' : 'checkInCircleFilled',
    'data-test-subj': 'trustedApps-filterEventsButton'
  }, {
    id: 'descendants',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 717,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 718,
        columnNumber: 15
      }
    }, _translations.PROCESS_DESCENDANTS_TRUSTED_APP), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 721,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 722,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.trustedApps.filterProcessDescendants.tooltip",
        defaultMessage: "When enabled, all child processes of a trusted parent process also become Trusted Applications. Supported by Elastic Agent v9.2+.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 723,
          columnNumber: 23
        }
      }))),
      "data-test-subj": "trustedAppsProcessDescendantsTooltip",
      iconProps: {
        'data-test-subj': 'trustedAppsProcessDescendantsTooltipIcon'
      },
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 719,
        columnNumber: 15
      }
    })),
    iconType: isProcessDescendantsSelected ? 'checkInCircleFilled' : 'empty',
    'data-test-subj': 'trustedApps-filterProcessDescendantsButton'
  }], [isProcessDescendantsSelected]);
  const filterTypeSubsection = (0, _react.useMemo)(() => {
    if (!isProcessDescendantsFeatureForTrustedAppsEnabled) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      legend: "Events or Process descendants selector",
      color: "primary",
      onChange: handleFilterTypeOnChange,
      options: filterTypeOptions,
      idSelected: isProcessDescendantsSelected ? 'descendants' : 'events',
      "data-test-subj": "trustedApps-processDescendantsSelector",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 747,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 755,
        columnNumber: 11
      }
    }), isProcessDescendantsSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 758,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedApps.filterProcessDescendants.additionalConditionDescription",
      defaultMessage: "Additional condition added:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 759,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 764,
        columnNumber: 15
      }
    }, _constants2.PROCESS_DESCENDANT_EXTRA_ENTRY_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 765,
        columnNumber: 15
      }
    })));
  }, [isProcessDescendantsFeatureForTrustedAppsEnabled, handleFilterTypeOnChange, filterTypeOptions, isProcessDescendantsSelected]);
  (0, _react.useEffect)(() => {
    processChanged();
  }, [processChanged]);
  if (isIndexPatternLoading || !trustedApp) {
    return /*#__PURE__*/_react.default.createElement(_loader.Loader, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 782,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    "data-test-subj": getTestId(''),
    error: submitError ? /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: submitError,
      "data-test-subj": getTestId('submitError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 791,
        columnNumber: 13
      }
    }) : undefined,
    isInvalid: !!submitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 786,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 796,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 797,
      columnNumber: 11
    }
  }, _translations.DETAILS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 799,
      columnNumber: 9
    }
  }), mode === 'create' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('about'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 801,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 802,
      columnNumber: 13
    }
  }, _translations.DETAILS_HEADER_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 806,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_artifacts_docs_link.TrustedAppsArtifactsDocsLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 807,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 813,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.NAME_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('nameRow'),
    isInvalid: visited.name && ((_validationResult$res = validationResult.result.name) === null || _validationResult$res === void 0 ? void 0 : _validationResult$res.isInvalid),
    error: (_validationResult$res2 = validationResult.result.name) === null || _validationResult$res2 === void 0 ? void 0 : _validationResult$res2.errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 814,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: visited.name && ((_validationResult$res3 = validationResult.result.name) === null || _validationResult$res3 === void 0 ? void 0 : _validationResult$res3.isInvalid),
    name: "name",
    value: item.name,
    onChange: handleOnNameOrDescriptionChange,
    onBlur: handleOnNameBlur,
    fullWidth: true,
    required: visited.name,
    maxLength: 256,
    "data-test-subj": getTestId('nameTextField'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 821,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.DESCRIPTION_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('descriptionRow'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 833,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: item.description,
    onChange: handleOnNameOrDescriptionChange,
    fullWidth: true,
    compressed: true,
    maxLength: 256,
    "data-test-subj": getTestId('descriptionField'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 838,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 848,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 849,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 850,
      columnNumber: 11
    }
  }, _translations.CONDITIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 852,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 853,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 854,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 855,
      columnNumber: 13
    }
  }, _translations.CONDITIONS_HEADER_DESCRIPTION)), isTAAdvancedModeFeatureFlagEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 858,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 859,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.StyledButtonGroup, {
    legend: "Advanced Mode Toggle",
    color: "primary",
    "data-test-subj": getTestId('advancedModeToggle'),
    options: advancedModeToggle,
    idSelected: selectedFormType,
    onChange: handleAdvancedModeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 860,
      columnNumber: 17
    }
  })))), isTAAdvancedModeFeatureFlagEnabled && isFormAdvancedMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 874,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 875,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 876,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warningFilled",
    size: "s",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 877,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 879,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "warning",
    "data-test-subj": getTestId('advancedModeUsageWarningHeader'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 880,
      columnNumber: 17
    }
  }, _translations.USING_ADVANCED_MODE))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "warning",
    "data-test-subj": getTestId('advancedModeUsageWarningBody'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 889,
      columnNumber: 13
    }
  }, _translations.USING_ADVANCED_MODE_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 898,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.SELECT_OS_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('OsRow'),
    isInvalid: (visited === null || visited === void 0 ? void 0 : visited.os) && ((_validationResult$res4 = validationResult.result.os) === null || _validationResult$res4 === void 0 ? void 0 : _validationResult$res4.isInvalid),
    error: (_validationResult$res5 = validationResult.result.os) === null || _validationResult$res5 === void 0 ? void 0 : _validationResult$res5.errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 899,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "os",
    options: osOptions,
    valueOfSelected: selectedOs,
    onChange: handleOnOsChange,
    fullWidth: true,
    "data-test-subj": getTestId('osSelectField'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 906,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 916,
      columnNumber: 9
    }
  }), isTAAdvancedModeFeatureFlagEnabled && isFormAdvancedMode && isProcessDescendantsFeatureForTrustedAppsEnabled && filterTypeSubsection, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": getTestId('conditionsRow'),
    isInvalid: visited.entries && ((_validationResult$res6 = validationResult.result.entries) === null || _validationResult$res6 === void 0 ? void 0 : _validationResult$res6.isInvalid),
    error: (_validationResult$res7 = validationResult.result.entries) === null || _validationResult$res7 === void 0 ? void 0 : _validationResult$res7.errors,
    helpText: (_validationResult$res8 = validationResult.result.entries) === null || _validationResult$res8 === void 0 ? void 0 : _validationResult$res8.warnings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 922,
      columnNumber: 9
    }
  }, isTAAdvancedModeFeatureFlagEnabled && isFormAdvancedMode ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exceptionBuilderComponentMemo, conditionsState.hasWildcardWithWrongOperator && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.WildCardWithWrongOperatorCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 932,
      columnNumber: 64
    }
  }), conditionsState.hasWildcardWithWrongOperator && conditionsState.hasPartialCodeSignatureWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 934,
      columnNumber: 67
    }
  }), conditionsState.hasPartialCodeSignatureWarning && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.PartialCodeSignatureCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 935,
      columnNumber: 66
    }
  })) : /*#__PURE__*/_react.default.createElement(_logical_condition.LogicalConditionBuilder, {
    entries: trustedApp.entries,
    os: selectedOs,
    onAndClicked: handleAndClick,
    onEntryRemove: handleEntryRemove,
    onEntryChange: handleEntryChange,
    onVisited: handleConditionBuilderOnVisited,
    "data-test-subj": getTestId('conditionsBuilder'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 938,
      columnNumber: 13
    }
  })), showAssignmentSection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 951,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": getTestId('policySelection'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 952,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    item: item,
    description: _translations.POLICY_SELECT_DESCRIPTION,
    "data-test-subj": getTestId('effectedPolicies'),
    onChange: handleEffectedPolicyOnChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 953,
      columnNumber: 15
    }
  }))) : null);
});
TrustedAppsForm.displayName = 'TrustedAppsForm';