"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyArtifactCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../../../../common/components/user_privileges");
var _translations = require("../translations");
var _use_can_access_some_artifacts = require("../../hooks/use_can_access_some_artifacts");
var _services = require("../../../../../blocklist/services");
var _api_client = require("../../../../../trusted_devices/service/api_client");
var _host_isolation_exceptions_api_client = require("../../../../../host_isolation_exceptions/host_isolation_exceptions_api_client");
var _api_client2 = require("../../../../../event_filters/service/api_client");
var _service = require("../../../../../trusted_apps/service");
var _routing = require("../../../../../../common/routing");
var _constants = require("../../../../../trusted_apps/constants");
var _fleet_integration_artifacts_card = require("./fleet_integration_artifacts_card");
var _constants2 = require("../../../../../event_filters/constants");
var _constants3 = require("../../../../../host_isolation_exceptions/constants");
var _constants4 = require("../../../../../blocklist/constants");
var _constants5 = require("../../../../../trusted_devices/constants");
var _use_experimental_features = require("../../../../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../../../../common/lib/kibana");
var _use_license = require("../../../../../../../common/hooks/use_license");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_policy_edit_extension/components/endpoint_policy_artifact_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TrustedAppsPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const trustedAppsApiClientInstance = (0, _react.useMemo)(() => _service.TrustedAppsApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyTrustedAppsPath)(policyId);
    }
    return (0, _routing.getTrustedAppsListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: trustedAppsApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants.SEARCHABLE_FIELDS,
    labels: _translations.TRUSTED_APPS_LABELS,
    "data-test-subj": "trustedApps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
});
TrustedAppsPolicyCard.displayName = 'TrustedAppsPolicyCard';
const TrustedDevicesPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const trustedDevicesApiClientInstance = (0, _react.useMemo)(() => _api_client.TrustedDevicesApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyTrustedDevicesPath)(policyId);
    }
    return (0, _routing.getTrustedDevicesListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: trustedDevicesApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants5.SEARCHABLE_FIELDS,
    labels: _translations.TRUSTED_DEVICES_LABELS,
    "data-test-subj": "trustedDevices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  });
});
TrustedDevicesPolicyCard.displayName = 'TrustedDevicesPolicyCard';
const EventFiltersPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const eventFiltersApiClientInstance = (0, _react.useMemo)(() => _api_client2.EventFiltersApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyEventFiltersPath)(policyId);
    }
    return (0, _routing.getEventFiltersListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: eventFiltersApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants2.SEARCHABLE_FIELDS,
    labels: _translations.EVENT_FILTERS_LABELS,
    "data-test-subj": "eventFilters",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  });
});
EventFiltersPolicyCard.displayName = 'EventFiltersPolicyCard';
const HostIsolationExceptionsPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const hostIsolationExceptionsApiClientInstance = (0, _react.useMemo)(() => _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyHostIsolationExceptionsPath)(policyId);
    }
    return (0, _routing.getHostIsolationExceptionsListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: hostIsolationExceptionsApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants3.SEARCHABLE_FIELDS,
    labels: _translations.HOST_ISOLATION_EXCEPTIONS_LABELS,
    "data-test-subj": "hostIsolationExceptions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  });
});
HostIsolationExceptionsPolicyCard.displayName = 'HostIsolationExceptionsPolicyCard';
const BlocklistPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const blocklistsApiClientInstance = (0, _react.useMemo)(() => _services.BlocklistsApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyBlocklistsPath)(policyId);
    }
    return (0, _routing.getBlocklistsListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: blocklistsApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants4.SEARCHABLE_FIELDS,
    labels: _translations.BLOCKLISTS_LABELS,
    "data-test-subj": "blocklists",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  });
});
BlocklistPolicyCard.displayName = 'BlocklistPolicyCard';
/**
 * Displays the Artifact cards on the Edit Integration Policy form within Fleet according to the
 * current user's authz
 */
const EndpointPolicyArtifactCards = exports.EndpointPolicyArtifactCards = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const {
    loading,
    canReadBlocklist,
    canReadEventFilters,
    canReadTrustedApplications,
    canReadHostIsolationExceptions,
    canReadTrustedDevices
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const canAccessArtifactContent = (0, _use_can_access_some_artifacts.useCanAccessSomeArtifacts)();
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const trustedDevicesVisible = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('trustedDevices') && canReadTrustedDevices && isEnterprise;
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 4,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 14
      }
    });
  }
  if (!canAccessArtifactContent) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.artifacts.title",
    defaultMessage: "Artifacts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }), canReadTrustedApplications && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TrustedAppsPolicyCard, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  })), trustedDevicesVisible && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TrustedDevicesPolicyCard, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 15
    }
  })), canReadEventFilters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EventFiltersPolicyCard, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  })), canReadHostIsolationExceptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(HostIsolationExceptionsPolicyCard, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  })), canReadBlocklist && /*#__PURE__*/_react.default.createElement(BlocklistPolicyCard, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 32
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 9
    }
  }));
});
EndpointPolicyArtifactCards.displayName = 'EndpointPolicyArtifactCards';