"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetArtifactsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/fleet-plugin/public");
var _common = require("@kbn/fleet-plugin/common");
var _kibana = require("../../../../../../../common/lib/kibana");
var _hooks = require("../../../../../../../common/lib/kibana/hooks");
var _link_with_icon = require("../../components/link_with_icon");
var _exception_items_summary = require("../../components/exception_items_summary");
var _styled_components = require("./styled_components");
var _artifacts = require("../../../../../../hooks/artifacts");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_package_custom_extension/components/fleet_artifacts_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ARTIFACTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.artifactsSummaryError', {
    defaultMessage: 'There was an error trying to fetch artifacts stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetCustomExtension.title",
    defaultMessage: "Artifacts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  })
};
const FleetArtifactsCard = exports.FleetArtifactsCard = /*#__PURE__*/(0, _react.memo)(({
  pkgkey,
  artifactApiClientInstance,
  getArtifactsPath,
  labels = ARTIFACTS_LABELS,
  'data-test-subj': dataTestSubj
}) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const toasts = (0, _kibana.useToasts)();
  const artifactsListUrlPath = getArtifactsPath();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    data
  } = (0, _artifacts.useSummaryArtifact)(artifactApiClientInstance, {}, [], {
    onError: error => toasts.addDanger(labels.artifactsSummaryApiError(error.message))
  });
  const artifactsRouteState = (0, _react.useMemo)(() => {
    const fleetPackageCustomUrlPath = `#${_public.pagePathGetters.integration_details_custom({
      pkgkey
    })[1]}`;
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.backButtonLabel', {
        defaultMessage: 'Return to Elastic Defend integration'
      }),
      onBackButtonNavigateTo: [_common.INTEGRATIONS_PLUGIN_ID, {
        path: fleetPackageCustomUrlPath
      }],
      backButtonUrl: getAppUrl({
        appId: _common.INTEGRATIONS_PLUGIN_ID,
        path: fleetPackageCustomUrlPath
      })
    };
  }, [getAppUrl, pkgkey]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    hasBorder: true,
    "data-test-subj": getTestId('fleetCard'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridGroup, {
    alignItems: "baseline",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridItem, {
    gridarea: "title",
    alignitems: "flex-start",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, labels.cardTitle))), /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridItem, {
    gridarea: "summary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_exception_items_summary.ExceptionItemsSummary, {
    stats: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexGridItem, {
    gridarea: "link",
    alignitems: "flex-end",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_link_with_icon.LinkWithIcon, {
    href: getAppUrl({
      path: artifactsListUrlPath
    }),
    appPath: artifactsListUrlPath,
    appState: artifactsRouteState,
    "data-test-subj": getTestId('artifactsLink'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetCustomExtension.manageArtifactsLinkLabel",
    defaultMessage: "Manage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }))))));
});
FleetArtifactsCard.displayName = 'FleetArtifactsCard';