"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointExceptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _endpoint_exceptions_form = require("./components/endpoint_exceptions_form");
var _api_client = require("../service/api_client");
var _constants = require("../constants");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_exceptions/view/endpoint_exceptions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointExceptions = exports.EndpointExceptions = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteEndpointExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const endpointExceptionsApiClient = _api_client.EndpointExceptionsApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: endpointExceptionsApiClient,
    ArtifactFormComponent: _endpoint_exceptions_form.EndpointExceptionsForm,
    labels: _translations.ENDPOINT_EXCEPTIONS_PAGE_LABELS,
    "data-test-subj": "endpointExceptionsListPage",
    searchableFields: _constants.ENDPOINT_EXCEPTIONS_SEARCHABLE_FIELDS,
    flyoutSize: "l",
    allowCardCreateAction: canWriteEndpointExceptions,
    allowCardEditAction: canWriteEndpointExceptions,
    allowCardDeleteAction: canWriteEndpointExceptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
});
EndpointExceptions.displayName = 'EndpointExceptions';