"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreationErrorMessage = exports.OS_LABEL = exports.NAME_LABEL = exports.NAME_ERROR = exports.ENDPOINT_EXCEPTIONS_PAGE_LABELS = exports.DESCRIPTION_LABEL = exports.ABOUT_ENDPOINT_EXCEPTIONS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_exceptions/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ENDPOINT_EXCEPTIONS_PAGE_LABELS = exports.ENDPOINT_EXCEPTIONS_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.pageTitle', {
    defaultMessage: 'Endpoint exceptions'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.pageAboutInfo', {
    defaultMessage: 'Endpoint exceptions prevent generating an alert by Defend integration on the host.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.pageAddButtonTitle', {
    defaultMessage: 'Add endpoint exception'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {endpoint exception} other {endpoint exceptions}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.cardActionEditLabel', {
    defaultMessage: 'Edit endpoint exception'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.cardActionDeleteLabel', {
    defaultMessage: 'Delete endpoint exception'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateTitle', {
    defaultMessage: 'Add endpoint exception'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutEditTitle', {
    defaultMessage: 'Edit endpoint exception'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add endpoint exception'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your endpoint exceptions.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointExceptions.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.endpointArtifacts}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointExceptions.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "endpoint exceptions documentation.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from endpoint exceptions.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no endpoint exceptions to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStateTitle', {
    defaultMessage: 'Add your first endpoint exception entry'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStateInfo', {
    defaultMessage: 'Endpoint exceptions prevent generating an alert by Defend integration on the host.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add endpoint exception'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const ABOUT_ENDPOINT_EXCEPTIONS = exports.ABOUT_ENDPOINT_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.aboutInfo', {
  defaultMessage: 'Endpoint exceptions prevent generating an alert by Defend integration on the host.'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.form.name.label', {
  defaultMessage: 'Name'
});
const OS_LABEL = exports.OS_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.form.os.label', {
  defaultMessage: 'Select operating system'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.form.description.placeholder', {
  defaultMessage: 'Description'
});
const NAME_ERROR = exports.NAME_ERROR = _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.form.name.error', {
  defaultMessage: "The name can't be empty"
});
const getCreationErrorMessage = creationError => {
  return {
    title: _i18n.i18n.translate('xpack.securitySolution.endpointExceptions.flyoutCreateErrorToastTitle', {
      defaultMessage: 'There was an error creating the new endpoint exception.'
    }),
    message: {
      error: creationError.message
    }
  };
};
exports.getCreationErrorMessage = getCreationErrorMessage;