"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendMemoryDumpRequest = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create a new request for a memory dump response action
 * @param options
 */
const useSendMemoryDumpRequest = options => {
  return (0, _reactQuery.useMutation)(reqBody => {
    return _kibana.KibanaServices.get().http.post(_constants.MEMORY_DUMP_ROUTE, {
      body: JSON.stringify(reqBody),
      version: '2023-10-31'
    });
  }, options);
};
exports.useSendMemoryDumpRequest = useSendMemoryDumpRequest;