"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsLog = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/endpoint/service/response_actions/constants");
var _management_empty_state_wrapper = require("../management_empty_state_wrapper");
var _hooks = require("../../hooks");
var _translations = require("./translations");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _actions_log_filters = require("./components/actions_log_filters");
var _hooks2 = require("./components/hooks");
var _use_action_history_url_params = require("./components/use_action_history_url_params");
var _use_url_pagination = require("../../hooks/use_url_pagination");
var _management_page_loader = require("../management_page_loader");
var _actions_log_empty_state = require("./components/actions_log_empty_state");
var _actions_log_table = require("./components/actions_log_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/response_actions_log.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResponseActionsLog = exports.ResponseActionsLog = /*#__PURE__*/(0, _react.memo)(({
  agentIds,
  showHostNames = false,
  isFlyout = true,
  setIsDataInResponse,
  'data-test-subj': dataTestSubj = 'response-actions-list',
  'data-test-height': dataTestHeight
}) => {
  var _error$body3, _error$body4;
  const {
    pagination: paginationFromUrlParams,
    setPagination: setPaginationOnUrlParams
  } = (0, _use_url_pagination.useUrlPagination)();
  const {
    agentTypes: agentTypesFromUrl,
    commands: commandsFromUrl,
    hosts: agentIdsFromUrl,
    statuses: statusesFromUrl,
    users: usersFromUrl,
    types: actionTypesFromUrl,
    withOutputs: withOutputsFromUrl,
    setUrlWithOutputs
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);

  // Used to decide if display global loader or not (only the fist time tha page loads)
  const [isFirstAttempt, setIsFirstAttempt] = (0, _react.useState)(true);
  const [queryParams, setQueryParams] = (0, _react.useState)({
    page: isFlyout ? 1 : paginationFromUrlParams.page,
    pageSize: isFlyout ? 10 : paginationFromUrlParams.pageSize,
    agentIds: isFlyout ? agentIds : agentIdsFromUrl !== null && agentIdsFromUrl !== void 0 && agentIdsFromUrl.length ? agentIdsFromUrl : agentIds,
    agentTypes: [],
    commands: [],
    statuses: [],
    userIds: [],
    withOutputs: [],
    types: []
  });

  // update query state from URL params
  (0, _react.useEffect)(() => {
    if (!isFlyout) {
      setQueryParams(prevState => ({
        ...prevState,
        agentTypes: agentTypesFromUrl !== null && agentTypesFromUrl !== void 0 && agentTypesFromUrl.length ? agentTypesFromUrl : prevState.agentTypes,
        commands: commandsFromUrl !== null && commandsFromUrl !== void 0 && commandsFromUrl.length ? commandsFromUrl.map(commandFromUrl => _constants.RESPONSE_CONSOLE_COMMAND_TO_API_COMMAND_MAP[commandFromUrl]) : prevState.commands,
        hosts: agentIdsFromUrl !== null && agentIdsFromUrl !== void 0 && agentIdsFromUrl.length ? agentIdsFromUrl : prevState.agentIds,
        statuses: statusesFromUrl !== null && statusesFromUrl !== void 0 && statusesFromUrl.length ? statusesFromUrl : prevState.statuses,
        userIds: usersFromUrl !== null && usersFromUrl !== void 0 && usersFromUrl.length ? usersFromUrl : prevState.userIds,
        withOutputs: withOutputsFromUrl !== null && withOutputsFromUrl !== void 0 && withOutputsFromUrl.length ? withOutputsFromUrl : prevState.withOutputs,
        types: actionTypesFromUrl !== null && actionTypesFromUrl !== void 0 && actionTypesFromUrl.length ? actionTypesFromUrl : prevState.types
      }));
    }
  }, [actionTypesFromUrl, agentTypesFromUrl, commandsFromUrl, agentIdsFromUrl, isFlyout, statusesFromUrl, setQueryParams, usersFromUrl, withOutputsFromUrl]);

  // date range picker state and handlers
  const {
    dateRangePickerState,
    onRefreshChange,
    onTimeChange
  } = (0, _hooks2.useDateRangePicker)(isFlyout);

  // initial fetch of list data
  const {
    error,
    data: actionList,
    isFetching,
    isFetched,
    refetch: reFetchEndpointActionList
  } = (0, _hooks.useGetEndpointActionList)({
    ...queryParams,
    startDate: dateRangePickerState.startDate,
    endDate: dateRangePickerState.endDate
  }, {
    retry: false
  });

  // total actions
  const totalItemCount = (0, _react.useMemo)(() => {
    var _actionList$total;
    return (_actionList$total = actionList === null || actionList === void 0 ? void 0 : actionList.total) !== null && _actionList$total !== void 0 ? _actionList$total : 0;
  }, [actionList]);
  // table items
  const tableItems = (0, _react.useMemo)(() => {
    var _actionList$data;
    return (_actionList$data = actionList === null || actionList === void 0 ? void 0 : actionList.data) !== null && _actionList$data !== void 0 ? _actionList$data : [];
  }, [actionList === null || actionList === void 0 ? void 0 : actionList.data]);

  // Hide page header when there is no actions index calling the setIsDataInResponse with false value.
  // Otherwise, it shows the page header calling the setIsDataInResponse with true value and it also keeps track
  // if the API request was done for the first time.
  (0, _react.useEffect)(() => {
    var _error$body, _error$body2;
    if (!isFetching && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404 && (error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) === 'index_not_found_exception') {
      if (setIsDataInResponse) {
        setIsDataInResponse(false);
      }
    } else if (!isFetching && actionList) {
      setIsFirstAttempt(false);
      if (setIsDataInResponse) {
        setIsDataInResponse(true);
      }
    }
  }, [actionList, error, isFetching, setIsDataInResponse]);

  // handle auto refresh data
  const onRefresh = (0, _react.useCallback)(() => {
    if (dateRangePickerState.autoRefreshOptions.enabled) {
      reFetchEndpointActionList();
    }
  }, [dateRangePickerState.autoRefreshOptions.enabled, reFetchEndpointActionList]);

  // handle on change actions filter
  const onChangeCommandsFilter = (0, _react.useCallback)(selectedCommands => {
    setQueryParams(prevState => ({
      ...prevState,
      commands: selectedCommands
    }));
  }, [setQueryParams]);

  // handle on change actions filter
  const onChangeStatusesFilter = (0, _react.useCallback)(selectedStatuses => {
    setQueryParams(prevState => ({
      ...prevState,
      statuses: selectedStatuses
    }));
  }, [setQueryParams]);
  const onChangeAgentTypesFilter = (0, _react.useCallback)(selectedAgentTypes => {
    setQueryParams(prevState => ({
      ...prevState,
      agentTypes: selectedAgentTypes
    }));
  }, [setQueryParams]);
  const onChangeTypeFilter = (0, _react.useCallback)(selectedTypes => {
    setQueryParams(prevState => ({
      ...prevState,
      types: selectedTypes
    }));
  }, [setQueryParams]);

  // handle on change hosts filter
  const onChangeHostsFilter = (0, _react.useCallback)(selectedAgentIds => {
    setQueryParams(prevState => ({
      ...prevState,
      agentIds: selectedAgentIds
    }));
  }, [setQueryParams]);

  // handle on change users filter
  const onChangeUsersFilter = (0, _react.useCallback)(selectedUserIds => {
    setQueryParams(prevState => ({
      ...prevState,
      userIds: selectedUserIds
    }));
  }, [setQueryParams]);

  // handle onChange
  const handleTableOnChange = (0, _react.useCallback)(({
    page: _page
  }) => {
    // table paging is 0 based
    const {
      index,
      size
    } = _page;
    // adjust the page to conform to
    // 1-based API page
    const pagingArgs = {
      page: index + 1,
      pageSize: size
    };
    setQueryParams(prevState => ({
      ...prevState,
      ...pagingArgs
    }));
    if (!isFlyout) {
      setPaginationOnUrlParams({
        ...pagingArgs
      });
    }
    reFetchEndpointActionList();
  }, [isFlyout, reFetchEndpointActionList, setQueryParams, setPaginationOnUrlParams]);

  // handle on details open
  const onShowActionDetails = (0, _react.useCallback)(actionIds => {
    setQueryParams(prevState => ({
      ...prevState,
      withOutputs: actionIds
    }));
    if (!isFlyout) {
      // set and show `withOutputs` URL param on history page
      setUrlWithOutputs(actionIds.join());
    }
  }, [isFlyout, setUrlWithOutputs, setQueryParams]);
  if ((error === null || error === void 0 ? void 0 : (_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : _error$body3.statusCode) === 404 && (error === null || error === void 0 ? void 0 : (_error$body4 = error.body) === null || _error$body4 === void 0 ? void 0 : _error$body4.message) === 'index_not_found_exception') {
    return /*#__PURE__*/_react.default.createElement(_actions_log_empty_state.ActionsLogEmptyState, {
      "data-test-subj": getTestId('empty-state'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 14
      }
    });
  } else if (isFetching && isFirstAttempt) {
    return /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
      "data-test-subj": getTestId('global-loader'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_actions_log_filters.ActionsLogFilters, {
    isFlyout: isFlyout,
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isFetching,
    onClick: reFetchEndpointActionList,
    onChangeHostsFilter: onChangeHostsFilter,
    onChangeCommandsFilter: onChangeCommandsFilter,
    onChangeStatusesFilter: onChangeStatusesFilter,
    onChangeUsersFilter: onChangeUsersFilter,
    onChangeAgentTypesFilter: onChangeAgentTypesFilter,
    onChangeTypeFilter: onChangeTypeFilter,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    showHostsFilter: showHostNames,
    "data-test-subj": dataTestSubj,
    "data-test-height": dataTestHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 9
    }
  }), isFetched && !totalItemCount ? /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": getTestId('empty-prompt'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "editorUnorderedList",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.responseActionsList.empty.title",
      defaultMessage: "No results match your search criteria",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 21
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.responseActionsList.empty.body",
      defaultMessage: "Try modifying your search or filter set",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 21
      }
    })),
    "data-test-subj": "responseActions-empty",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_actions_log_table.ActionsLogTable, {
    "data-test-subj": dataTestSubj,
    error: error !== null ? _translations.UX_MESSAGES.fetchError : undefined,
    items: tableItems,
    isFlyout: isFlyout,
    loading: isFetching,
    onChange: handleTableOnChange,
    onShowActionDetails: onShowActionDetails,
    queryParams: queryParams,
    showHostNames: showHostNames,
    totalItemCount: totalItemCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }));
});
ResponseActionsLog.displayName = 'ResponseActionsLog';