"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogFilter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _type_guards = require("../../../../../common/endpoint/service/response_actions/type_guards");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _actions_log_filter_popover = require("./actions_log_filter_popover");
var _hooks = require("./hooks");
var _clear_all_button = require("./clear_all_button");
var _translations = require("../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/actions_log_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionsLogFilter = exports.ActionsLogFilter = /*#__PURE__*/(0, _react.memo)(({
  filterName,
  typesFilters,
  isFlyout,
  onChangeFilterOptions,
  'data-test-subj': dataTestSubj,
  'data-test-height': dataTestHeight
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);

  // popover states and handlers
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onPopoverButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [setIsPopoverOpen, isPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);

  // search string state
  const [searchString, setSearchString] = (0, _react.useState)('');
  const {
    areHostsSelectedOnMount,
    isLoading,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreHostsSelectedOnMount,
    setUrlActionsFilters,
    setUrlHostsFilters,
    setUrlStatusesFilters,
    setUrlTypesFilters
  } = (0, _hooks.useActionsLogFilter)({
    filterName,
    isFlyout,
    searchString
  });

  // track popover state to pin selected options
  const wasPopoverOpen = (0, _react.useRef)(isPopoverOpen);
  (0, _react.useEffect)(() => {
    return () => {
      wasPopoverOpen.current = isPopoverOpen;
    };
  }, [isPopoverOpen, wasPopoverOpen]);

  // compute if selected hosts should be pinned
  const shouldPinSelectedHosts = (0, _react.useCallback)((isNotChangingOptions = true) => {
    // case 1: when no hosts are selected initially
    return isNotChangingOptions && wasPopoverOpen.current && isPopoverOpen && filterName === 'hosts';
  }, [filterName, isPopoverOpen]);

  // augmented options based on the host filter
  const sortedHostsFilterOptions = (0, _react.useMemo)(() => {
    if (shouldPinSelectedHosts() || areHostsSelectedOnMount) {
      // pin checked items to the top
      return (0, _fp.orderBy)('checked', 'asc', items);
    }
    // return options as are for other filters
    return items;
  }, [areHostsSelectedOnMount, shouldPinSelectedHosts, items]);
  const isSearchable = (0, _react.useMemo)(() => filterName !== 'statuses' && filterName !== 'types', [filterName]);
  const onOptionsChange = (0, _react.useCallback)(newOptions => {
    // update filter UI options state
    setItems(newOptions.map(option => option));

    // compute a selected list of options
    const selectedItems = newOptions.reduce((acc, curr) => {
      if (curr.checked === 'on' && curr.key) {
        acc.push(curr.key);
      }
      return acc;
    }, []);
    const groupedSelectedTypeFilterOptions = selectedItems.reduce((acc, item) => {
      if ((0, _type_guards.isAgentType)(item)) {
        acc.agentTypes.push(item);
      }
      if ((0, _type_guards.isActionType)(item)) {
        acc.actionTypes.push(item);
      }
      return acc;
    }, {
      actionTypes: [],
      agentTypes: []
    });
    if (!isFlyout) {
      // update URL params
      if (filterName === 'actions') {
        setUrlActionsFilters(selectedItems.map(item => _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[item]).join());
      } else if (filterName === 'hosts') {
        setUrlHostsFilters(selectedItems.join());
      } else if (filterName === 'statuses') {
        setUrlStatusesFilters(selectedItems.join());
      } else if (filterName === 'types') {
        setUrlTypesFilters({
          agentTypes: groupedSelectedTypeFilterOptions.agentTypes.join(),
          actionTypes: groupedSelectedTypeFilterOptions.actionTypes.join()
        });
      }
      // reset shouldPinSelectedHosts, setAreHostsSelectedOnMount
      shouldPinSelectedHosts(false);
      setAreHostsSelectedOnMount(false);
    }

    // update overall query state
    if (typesFilters && typeof onChangeFilterOptions === 'undefined') {
      typesFilters.agentTypes.onChangeFilterOptions(groupedSelectedTypeFilterOptions.agentTypes);
      typesFilters.actionTypes.onChangeFilterOptions(groupedSelectedTypeFilterOptions.actionTypes);
    } else {
      if (typeof onChangeFilterOptions !== 'undefined') {
        onChangeFilterOptions(selectedItems);
      }
    }
  }, [setItems, isFlyout, typesFilters, onChangeFilterOptions, filterName, shouldPinSelectedHosts, setAreHostsSelectedOnMount, setUrlActionsFilters, setUrlHostsFilters, setUrlStatusesFilters, setUrlTypesFilters]);

  // clear all selected options
  const onClearAll = (0, _react.useCallback)(() => {
    // update filter UI options state
    setItems(items.map(option => {
      option.checked = undefined;
      return option;
    }));
    if (!isFlyout) {
      // update URL params based on filter on page
      if (filterName === 'actions') {
        setUrlActionsFilters('');
      } else if (filterName === 'hosts') {
        setUrlHostsFilters('');
      } else if (filterName === 'statuses') {
        setUrlStatusesFilters('');
      } else if (filterName === 'types') {
        setUrlTypesFilters({
          agentTypes: '',
          actionTypes: ''
        });
      }
    }

    // update query state for flyout filters
    if (typesFilters && typeof onChangeFilterOptions === 'undefined') {
      typesFilters.agentTypes.onChangeFilterOptions([]);
      typesFilters.actionTypes.onChangeFilterOptions([]);
    } else {
      if (typeof onChangeFilterOptions !== 'undefined') {
        onChangeFilterOptions([]);
      }
    }
  }, [setItems, items, isFlyout, typesFilters, onChangeFilterOptions, filterName, setUrlActionsFilters, setUrlHostsFilters, setUrlStatusesFilters, setUrlTypesFilters]);
  return /*#__PURE__*/_react.default.createElement(_actions_log_filter_popover.ActionsLogFilterPopover, {
    closePopover: onClosePopover,
    filterName: filterName,
    hasActiveFilters: hasActiveFilters,
    isPopoverOpen: isPopoverOpen,
    numActiveFilters: numActiveFilters,
    numFilters: numFilters,
    onButtonClick: onPopoverButtonClick,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    height: dataTestHeight,
    "aria-label": `${filterName}`,
    emptyMessage: _translations.UX_MESSAGES.filterEmptyMessage(filterName),
    isLoading: isLoading,
    onChange: onOptionsChange,
    options: sortedHostsFilterOptions,
    searchable: isSearchable ? true : undefined,
    searchProps: {
      placeholder: _translations.UX_MESSAGES.filterSearchPlaceholder(filterName),
      compressed: true,
      onChange: searchValue => setSearchString(searchValue.trim())
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, (list, search) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: {
        width: 300
      },
      "data-test-subj": getTestId(`${filterName}-filter-popoverList`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 15
      }
    }, isSearchable && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      "data-test-subj": getTestId(`${filterName}-filter-search`),
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 19
      }
    }, search), list, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_clear_all_button.ClearAllButton, {
      "data-test-subj": getTestId(`${filterName}-filter-clearAllButton`),
      isDisabled: !hasActiveFilters,
      onClick: onClearAll,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 21
      }
    }))));
  }));
});
ActionsLogFilter.displayName = 'ActionsLogFilter';