"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionResponseOutputs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _type_guards = require("../../../../../common/endpoint/service/response_actions/type_guards");
var _response_action_file_download_link = require("../../response_action_file_download_link");
var _endpoint_execute_action = require("../../endpoint_execute_action");
var _endpoint_upload_action_result = require("../../endpoint_upload_action_result");
var _running_processes_action_results = require("../../running_processes_action_results");
var _runscript_action_result = require("../../runscript_action_result");
var _memory_dump_response_action_output_result = require("../../memory_dump_response_action_output_result");
var _user_privileges = require("../../../../common/components/user_privileges");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _translations = require("../translations");
var _endpoint_action_failure_message = require("../../endpoint_action_failure_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/action_response_outputs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Displays the response outputs for each of the agents that a response action was sent to
 */
const ActionResponseOutputs = exports.ActionResponseOutputs = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    canWriteFileOperations,
    canReadActionsLogManagement,
    canAccessEndpointActionsLogManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const hasMultipleAgents = (0, _react.useMemo)(() => {
    return action.agents.length > 1;
  }, [action.agents.length]);
  const consoleCommandName = (0, _react.useMemo)(() => {
    return _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[action.command];
  }, [action.command]);
  return (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, action.agents.map(agentId => {
      var _action$agentState$ag, _action$hosts$agentId, _action$hosts$agentId2;
      const {
        wasSuccessful,
        isCompleted,
        completedAt
      } = (_action$agentState$ag = action.agentState[agentId]) !== null && _action$agentState$ag !== void 0 ? _action$agentState$ag : {
        wasSuccessful: action.wasSuccessful,
        isCompleted: action.isCompleted,
        completedAt: action.completedAt
      };
      const hostStatusMessage = !isCompleted ? _translations.OUTPUT_MESSAGES.isPending(consoleCommandName) : wasSuccessful ? _translations.OUTPUT_MESSAGES.wasSuccessful(consoleCommandName) : action.isExpired ? _translations.OUTPUT_MESSAGES.hasExpired(consoleCommandName) : _translations.OUTPUT_MESSAGES.hasFailed(consoleCommandName);
      const hostName = (_action$hosts$agentId = (_action$hosts$agentId2 = action.hosts[agentId]) === null || _action$hosts$agentId2 === void 0 ? void 0 : _action$hosts$agentId2.name) !== null && _action$hosts$agentId !== void 0 ? _action$hosts$agentId : agentId;
      let hostOutput = null;
      if (isCompleted && wasSuccessful) {
        if ((0, _type_guards.isGetFileAction)(action)) {
          hostOutput = /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
            action: action,
            agentId: agentId,
            canAccessFileDownloadLink: canWriteFileOperations,
            textSize: "xs",
            "data-test-subj": getTestId('getFileDownloadLink'),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 81,
              columnNumber: 19
            }
          });
        }
        if ((0, _type_guards.isExecuteAction)(action)) {
          hostOutput = /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
            action: action,
            agentId: agentId,
            canAccessFileDownloadLink: canAccessEndpointActionsLogManagement || canReadActionsLogManagement,
            textSize: "xs",
            "data-test-subj": getTestId('actionsLogTray'),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 93,
              columnNumber: 19
            }
          });
        }
        if ((0, _type_guards.isUploadAction)(action)) {
          hostOutput = /*#__PURE__*/_react.default.createElement(_endpoint_upload_action_result.EndpointUploadActionResult, {
            action: action,
            agentId: agentId,
            "data-test-subj": getTestId('uploadOutput'),
            textSize: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 107,
              columnNumber: 19
            }
          });
        }
        if ((0, _type_guards.isProcessesAction)(action)) {
          hostOutput = /*#__PURE__*/_react.default.createElement(_running_processes_action_results.RunningProcessesActionResults, {
            action: action,
            agentId: agentId,
            "data-test-subj": "processesOutput",
            textSize: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 118,
              columnNumber: 19
            }
          });
        }
        if ((0, _type_guards.isRunScriptAction)(action)) {
          hostOutput = /*#__PURE__*/_react.default.createElement(_runscript_action_result.RunscriptActionResult, {
            action: action,
            "data-test-subj": getTestId('actionsLogTray'),
            textSize: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 129,
              columnNumber: 19
            }
          });
        }
        if ((0, _type_guards.isMemoryDumpAction)(action)) {
          hostOutput = /*#__PURE__*/_react.default.createElement(_memory_dump_response_action_output_result.MemoryDumpResponseActionOutputResult, {
            action: action,
            agentId: agentId,
            textSize: "xs",
            "data-test-subj": getTestId('memoryDumpOutput'),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 19
            }
          });
        }

        // CrowdStrike Isolate/Release actions
        if (action.agentType === 'crowdstrike') {
          hostOutput = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.OUTPUT_MESSAGES.submittedSuccessfully(consoleCommandName));
        }
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        key: agentId,
        "data-test-subj": getTestId(`${agentId}-output`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 15
        }
      }, hasMultipleAgents && /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 19
        }
      }, hostName, ': '), hostStatusMessage, isCompleted && /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 19
        }
      }, hasMultipleAgents && /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 23
        }
      }, _translations.OUTPUT_MESSAGES.expandSection.completedAt, " ", completedAt), wasSuccessful ? hostOutput : /*#__PURE__*/_react.default.createElement(_endpoint_action_failure_message.EndpointActionFailureMessage, {
        action: action,
        agentId: agentId,
        "data-test-subj": getTestId(`${agentId}-outputFailureMessage`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 23
        }
      })), hasMultipleAgents && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 39
        }
      }));
    }));
  }, [action, canAccessEndpointActionsLogManagement, canReadActionsLogManagement, canWriteFileOperations, consoleCommandName, getTestId, hasMultipleAgents]);
});
ActionResponseOutputs.displayName = 'ActionResponseOutputs';