"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptHelpContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console_argument_selectors/script_input_params_selector/shared/script_help_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ScriptHelpContent = exports.ScriptHelpContent = /*#__PURE__*/(0, _react.memo)(({
  description,
  instructions,
  example
}) => {
  const content = (0, _react.useMemo)(() => {
    const data = [];
    if (description) {
      data.push({
        title: _i18n.i18n.translate('xpack.securitySolution.scriptHelpContent.descriptionLabel', {
          defaultMessage: 'Description'
        }),
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 32,
            columnNumber: 15
          }
        }), description, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 15
          }
        }))
      });
    }
    if (instructions) {
      data.push({
        title: _i18n.i18n.translate('xpack.securitySolution.scriptHelpContent.instructionsLabel', {
          defaultMessage: 'Instructions'
        }),
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 15
          }
        }), instructions, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 15
          }
        }))
      });
    }
    if (example) {
      data.push({
        title: _i18n.i18n.translate('xpack.securitySolution.scriptHelpContent.exampleLabel', {
          defaultMessage: 'Example'
        }),
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 15
          }
        }), example, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 15
          }
        }))
      });
    }
    return data;
  }, [description, example, instructions]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: content,
    titleProps: {
      css: (0, _react2.css)`
              font-weight: unset !important;
              text-decoration: underline !important;
            `
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }));
});
ScriptHelpContent.displayName = 'ScriptHelpContent';