"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrustedDevicesListPath = exports.getTrustedAppsListPath = exports.getPolicyTrustedDevicesPath = exports.getPolicyTrustedAppsPath = exports.getPolicyProtectionUpdatesPath = exports.getPolicyHostIsolationExceptionsPath = exports.getPolicyEventFiltersPath = exports.getPolicyEndpointExceptionsPath = exports.getPolicyDetailsArtifactsListPath = exports.getPolicyDetailPath = exports.getPolicyBlocklistsPath = exports.getPoliciesPath = exports.getHostIsolationExceptionsListPath = exports.getEventFiltersListPath = exports.getEndpointListPath = exports.getEndpointExceptionsListPath = exports.getEndpointDetailsPath = exports.getBlocklistsListPath = exports.extractPolicyDetailsArtifactsListPageLocation = exports.extractListPaginationParams = exports.extractFirstParamValue = void 0;
var _fp = require("lodash/fp");
var _querystring = _interopRequireDefault(require("querystring"));
var _reactRouterDom = require("react-router-dom");
var _helpers = require("../../common/components/link_to/helpers");
var _use_url_pagination = require("../hooks/use_url_pagination");
var _types = require("../types");
var _constants = require("./constants");
var _url_routing = require("./url_routing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME: Remove references to `querystring`
// eslint-disable-next-line import/no-nodejs-modules

// Taken from: https://github.com/microsoft/TypeScript/issues/12936#issuecomment-559034150

/**
 * Returns a string to be used in the URL as search query params.
 * Ensures that when creating a URL query param string, that the given input strictly
 * matches the expected interface (guards against possibly leaking internal state)
 */
const querystringStringify = params => _querystring.default.stringify(params);

/** Make `selected_endpoint` required */

/** URL search params that are only applicable to the list page */

const getEndpointListPath = (props, search) => {
  const {
    name,
    ...queryParams
  } = props;
  const urlQueryParams = querystringStringify(queryParams);
  const urlSearch = `${urlQueryParams && !(0, _fp.isEmpty)(search) ? '&' : ''}${search !== null && search !== void 0 ? search : ''}`;
  if (name === 'endpointList') {
    return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_ENDPOINTS_PATH, {
      tabName: _types.AdministrationSubTab.endpoints
    })}${(0, _helpers.appendSearch)(`${urlQueryParams ? `${urlQueryParams}${urlSearch}` : urlSearch}`)}`;
  }
  return `${(0, _helpers.appendSearch)(`${urlQueryParams ? `${urlQueryParams}${urlSearch}` : urlSearch}`)}`;
};
exports.getEndpointListPath = getEndpointListPath;
const getEndpointDetailsPath = (props, search) => {
  const {
    name,
    show,
    ...rest
  } = props;
  const queryParams = {
    ...rest
  };
  switch (props.name) {
    case 'endpointDetails':
      queryParams.show = 'details';
      break;
    case 'endpointIsolate':
      queryParams.show = 'isolate';
      break;
    case 'endpointUnIsolate':
      queryParams.show = 'unisolate';
      break;
    case 'endpointPolicyResponse':
      queryParams.show = 'policy_response';
      break;
    case 'endpointActivityLog':
      queryParams.show = 'activity_log';
      break;
  }
  const urlQueryParams = querystringStringify(queryParams);
  const urlSearch = `${urlQueryParams && !(0, _fp.isEmpty)(search) ? '&' : ''}${search !== null && search !== void 0 ? search : ''}`;
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_ENDPOINTS_PATH, {
    tabName: _types.AdministrationSubTab.endpoints
  })}${(0, _helpers.appendSearch)(`${urlQueryParams ? `${urlQueryParams}${urlSearch}` : urlSearch}`)}`;
};
exports.getEndpointDetailsPath = getEndpointDetailsPath;
const getPoliciesPath = search => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICIES_PATH, {
    tabName: _types.AdministrationSubTab.policies
  })}${(0, _helpers.appendSearch)(search)}`;
};
exports.getPoliciesPath = getPoliciesPath;
const getPolicyDetailPath = (policyId, search) => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  })}${(0, _helpers.appendSearch)(search)}`;
};
exports.getPolicyDetailPath = getPolicyDetailPath;
const getPolicyTrustedAppsPath = (policyId, search) => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  })}${(0, _helpers.appendSearch)(search)}`;
};
exports.getPolicyTrustedAppsPath = getPolicyTrustedAppsPath;
const getPolicyTrustedDevicesPath = (policyId, location) => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_DEVICES_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  })}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyTrustedDevicesPath = getPolicyTrustedDevicesPath;
const getPolicyEventFiltersPath = (policyId, location) => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  })}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyEventFiltersPath = getPolicyEventFiltersPath;
const normalizePolicyDetailsArtifactsListPageLocation = location => {
  if (location) {
    return {
      ...(!(0, _url_routing.isDefaultOrMissing)(location.page, _constants.MANAGEMENT_DEFAULT_PAGE + 1) ? {
        page: location.page
      } : {}),
      ...(!(0, _url_routing.isDefaultOrMissing)(location.pageSize, _constants.MANAGEMENT_DEFAULT_PAGE_SIZE) ? {
        pageSize: location.pageSize
      } : {}),
      ...(!(0, _url_routing.isDefaultOrMissing)(location.show, undefined) ? {
        show: location.show
      } : {}),
      ...(!(0, _url_routing.isDefaultOrMissing)(location.filter, '') ? {
        filter: location.filter
      } : '')
    };
  } else {
    return {};
  }
};

/**
 * Given an object with url params, and a given key, return back only the first param value (case multiples were defined)
 * @param query
 * @param key
 */
const extractFirstParamValue = (query, key) => {
  const value = query[key];
  return Array.isArray(value) ? value[value.length - 1] : value;
};
exports.extractFirstParamValue = extractFirstParamValue;
const extractPageIndex = query => {
  const pageIndex = Number(extractFirstParamValue(query, 'page_index'));
  return !Number.isFinite(pageIndex) || pageIndex < 0 ? _constants.MANAGEMENT_DEFAULT_PAGE : pageIndex;
};
const extractPageSize = query => {
  const pageSize = Number(extractFirstParamValue(query, 'page_size'));
  return _constants.MANAGEMENT_PAGE_SIZE_OPTIONS.includes(pageSize) ? pageSize : _constants.MANAGEMENT_DEFAULT_PAGE_SIZE;
};
const extractFilter = query => {
  return extractFirstParamValue(query, 'filter') || '';
};
const extractListPaginationParams = query => ({
  page_index: extractPageIndex(query),
  page_size: extractPageSize(query),
  filter: extractFilter(query)
});
exports.extractListPaginationParams = extractListPaginationParams;
const getTrustedAppsListPath = location => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH, {
    tabName: _types.AdministrationSubTab.trustedApps
  });
  return (0, _url_routing.getArtifactListPageUrlPath)(path, location);
};
exports.getTrustedAppsListPath = getTrustedAppsListPath;
const getTrustedDevicesListPath = location => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_TRUSTED_DEVICES_PATH, {
    tabName: _types.AdministrationSubTab.trustedDevices
  });
  return (0, _url_routing.getArtifactListPageUrlPath)(path, location);
};
exports.getTrustedDevicesListPath = getTrustedDevicesListPath;
const extractPolicyDetailsArtifactsListPageLocation = query => {
  const showParamValue = extractFirstParamValue(query, 'show');
  const pagination = (0, _use_url_pagination.paginationFromUrlParams)(query);
  return {
    page: pagination.page,
    pageSize: pagination.pageSize,
    filter: query.filter,
    show: showParamValue && 'list' === showParamValue ? showParamValue : undefined
  };
};
exports.extractPolicyDetailsArtifactsListPageLocation = extractPolicyDetailsArtifactsListPageLocation;
const getPolicyDetailsArtifactsListPath = (policyId, location) => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  });
  return `${path}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyDetailsArtifactsListPath = getPolicyDetailsArtifactsListPath;
const getEventFiltersListPath = location => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH, {
    tabName: _types.AdministrationSubTab.eventFilters
  });
  return (0, _url_routing.getArtifactListPageUrlPath)(path, location);
};
exports.getEventFiltersListPath = getEventFiltersListPath;
const getHostIsolationExceptionsListPath = location => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH, {
    tabName: _types.AdministrationSubTab.hostIsolationExceptions
  });
  return (0, _url_routing.getArtifactListPageUrlPath)(path, location);
};
exports.getHostIsolationExceptionsListPath = getHostIsolationExceptionsListPath;
const getPolicyHostIsolationExceptionsPath = (policyId, location) => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  });
  return `${path}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyHostIsolationExceptionsPath = getPolicyHostIsolationExceptionsPath;
const getBlocklistsListPath = location => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_BLOCKLIST_PATH, {
    tabName: _types.AdministrationSubTab.blocklist
  });
  return (0, _url_routing.getArtifactListPageUrlPath)(path, location);
};
exports.getBlocklistsListPath = getBlocklistsListPath;
const getPolicyBlocklistsPath = (policyId, location) => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  });
  return `${path}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyBlocklistsPath = getPolicyBlocklistsPath;
const getEndpointExceptionsListPath = location => {
  const path = (0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_ENDPOINT_EXCEPTIONS_PATH, {
    tabName: _types.AdministrationSubTab.endpointExceptions
  });
  return (0, _url_routing.getArtifactListPageUrlPath)(path, location);
};
exports.getEndpointExceptionsListPath = getEndpointExceptionsListPath;
const getPolicyEndpointExceptionsPath = (policyId, location) => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_ENDPOINT_EXCEPTIONS_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  })}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyEndpointExceptionsPath = getPolicyEndpointExceptionsPath;
const getPolicyProtectionUpdatesPath = (policyId, location) => {
  return `${(0, _reactRouterDom.generatePath)(_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH, {
    tabName: _types.AdministrationSubTab.policies,
    policyId
  })}${(0, _helpers.appendSearch)(_querystring.default.stringify(normalizePolicyDetailsArtifactsListPageLocation(location)))}`;
};
exports.getPolicyProtectionUpdatesPath = getPolicyProtectionUpdatesPath;